/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.maven.util;

import com.qq.tars.maven.util.FilePermission;
import com.qq.tars.maven.util.FilePermissionUtils;
import java.io.File;
import java.lang.reflect.Method;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public final class ArchiveEntryUtils {
    public static boolean jvmFilePermAvailable = false;

    private ArchiveEntryUtils() {
    }

    public static void chmod(File file, int mode, Log logger, boolean useJvmChmod) throws ArchiverException {
        if (!Os.isFamily((String)"unix")) {
            return;
        }
        String m = Integer.toOctalString(mode & 0xFFF);
        if (useJvmChmod && !jvmFilePermAvailable) {
            logger.info((CharSequence)"chmod it's not possible where your current jvm");
            useJvmChmod = false;
        }
        if (useJvmChmod && jvmFilePermAvailable) {
            ArchiveEntryUtils.applyPermissionsWithJvm(file, m, logger);
            return;
        }
        try {
            Commandline commandline = new Commandline();
            commandline.setWorkingDirectory(file.getParentFile().getAbsolutePath());
            if (logger.isDebugEnabled()) {
                logger.debug((CharSequence)(file + ": mode " + Integer.toOctalString(mode) + ", chmod " + m));
            }
            commandline.setExecutable("chmod");
            commandline.createArg().setValue(m);
            String path = file.getAbsolutePath();
            commandline.createArg().setValue(path);
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)stderr, (StreamConsumer)stdout);
            if (exitCode != 0) {
                logger.warn((CharSequence)"-------------------------------");
                logger.warn((CharSequence)"Standard error:");
                logger.warn((CharSequence)"-------------------------------");
                logger.warn((CharSequence)stderr.getOutput());
                logger.warn((CharSequence)"-------------------------------");
                logger.warn((CharSequence)"Standard output:");
                logger.warn((CharSequence)"-------------------------------");
                logger.warn((CharSequence)stdout.getOutput());
                logger.warn((CharSequence)"-------------------------------");
                throw new ArchiverException("chmod exit code was: " + exitCode);
            }
        }
        catch (CommandLineException e) {
            throw new ArchiverException("Error while executing chmod.", (Throwable)e);
        }
    }

    public static void chmod(File file, int mode, Log logger) throws ArchiverException {
        ArchiveEntryUtils.chmod(file, mode, logger, Boolean.getBoolean("useJvmChmod") && jvmFilePermAvailable);
    }

    public static void applyPermissionsWithJvm(File file, String mode, Log logger) {
        FilePermission filePermission = FilePermissionUtils.getFilePermissionFromMode(mode, logger);
        try {
            Method method = File.class.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
            method.invoke((Object)file, filePermission.isReadable(), filePermission.isOwnerOnlyReadable());
            method = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            method.invoke((Object)file, filePermission.isExecutable(), filePermission.isOwnerOnlyExecutable());
            method = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
            method.invoke((Object)file, filePermission.isWritable(), filePermission.isOwnerOnlyWritable());
        }
        catch (Exception e) {
            logger.error((CharSequence)("error calling dynamically file permissions with jvm " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("error calling dynamically file permissions with jvm " + e.getMessage(), e);
        }
    }

    static {
        try {
            jvmFilePermAvailable = File.class.getMethod("setReadable", Boolean.TYPE) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

