/*
 * Decompiled with CFR 0.152.
 */
package com.turbomanage.httpclient;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ParameterMap
implements Map<String, String> {
    private Map<String, String> map = new HashMap<String, String>();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public String put(String key, String value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> arg) {
        this.map.putAll(arg);
    }

    @Override
    public String remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<String> values() {
        return this.map.values();
    }

    public ParameterMap add(String name, String value) {
        this.map.put(name, value);
        return this;
    }

    public String urlEncode() {
        StringBuilder sb = new StringBuilder();
        for (String key : this.map.keySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key);
            String value = this.map.get(key);
            if (value == null) continue;
            sb.append("=");
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public byte[] urlEncodedBytes() {
        byte[] bytes = null;
        try {
            bytes = this.urlEncode().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return bytes;
    }
}

