/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.debezium.event;

import com.ververica.cdc.common.annotation.Internal;
import com.ververica.cdc.common.types.DataField;
import com.ververica.cdc.common.types.DataType;
import com.ververica.cdc.common.types.DataTypes;
import com.ververica.cdc.debezium.event.SchemaDataTypeInference;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

@Internal
public class DebeziumSchemaDataTypeInference
implements SchemaDataTypeInference,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PRECISION_PARAMETER_KEY = "connect.decimal.precision";
    public static final int DEFAULT_DECIMAL_PRECISION = 20;

    @Override
    public DataType infer(Object value, Schema schema) {
        return schema.isOptional() ? this.infer(value, schema, schema.type()) : this.infer(value, schema, schema.type()).notNull();
    }

    protected DataType infer(Object value, Schema schema, Schema.Type type) {
        switch (type) {
            case INT8: {
                return this.inferInt8(value, schema);
            }
            case INT16: {
                return this.inferInt16(value, schema);
            }
            case INT32: {
                return this.inferInt32(value, schema);
            }
            case INT64: {
                return this.inferInt64(value, schema);
            }
            case FLOAT32: {
                return this.inferFloat32(value, schema);
            }
            case FLOAT64: {
                return this.inferFloat64(value, schema);
            }
            case BOOLEAN: {
                return this.inferBoolean(value, schema);
            }
            case STRING: {
                return this.inferString(value, schema);
            }
            case BYTES: {
                return this.inferBytes(value, schema);
            }
            case STRUCT: {
                return this.inferStruct(value, schema);
            }
            case ARRAY: {
                return this.inferArray(value, schema);
            }
            case MAP: {
                return this.inferMap(value, schema);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + schema.type().getName());
    }

    protected DataType inferBoolean(Object value, Schema schema) {
        return DataTypes.BOOLEAN();
    }

    protected DataType inferInt8(Object value, Schema schema) {
        return DataTypes.TINYINT();
    }

    protected DataType inferInt16(Object value, Schema schema) {
        return DataTypes.SMALLINT();
    }

    protected DataType inferInt32(Object value, Schema schema) {
        if ("org.apache.kafka.connect.data.Date".equals(schema.name())) {
            return DataTypes.DATE();
        }
        if ("io.debezium.time.Time".equals(schema.name())) {
            return DataTypes.TIME((int)3);
        }
        return DataTypes.INT();
    }

    protected DataType inferInt64(Object value, Schema schema) {
        if ("io.debezium.time.MicroTime".equals(schema.name())) {
            return DataTypes.TIME((int)6);
        }
        if ("io.debezium.time.NanoTime".equals(schema.name())) {
            return DataTypes.TIME((int)9);
        }
        if ("io.debezium.time.Timestamp".equals(schema.name())) {
            return DataTypes.TIMESTAMP((int)3);
        }
        if ("io.debezium.time.MicroTimestamp".equals(schema.name())) {
            return DataTypes.TIMESTAMP((int)6);
        }
        if ("io.debezium.time.NanoTimestamp".equals(schema.name())) {
            return DataTypes.TIMESTAMP((int)9);
        }
        return DataTypes.BIGINT();
    }

    protected DataType inferFloat32(Object value, Schema schema) {
        return DataTypes.FLOAT();
    }

    protected DataType inferFloat64(Object value, Schema schema) {
        return DataTypes.DOUBLE();
    }

    protected DataType inferString(Object value, Schema schema) {
        if ("io.debezium.time.ZonedTimestamp".equals(schema.name())) {
            int nano = Optional.ofNullable((String)value).map(Instant::parse).map(Instant::getNano).orElse(0);
            int precision = nano == 0 ? 0 : (nano % 1000 > 0 ? 9 : (nano % 1000000 > 0 ? 6 : (nano % 1000000000 > 0 ? 3 : 0)));
            return DataTypes.TIMESTAMP_LTZ((int)precision);
        }
        return DataTypes.STRING();
    }

    protected DataType inferBytes(Object value, Schema schema) {
        if ("org.apache.kafka.connect.data.Decimal".equals(schema.name())) {
            int scale = Optional.ofNullable((String)schema.parameters().get("scale")).map(Integer::parseInt).orElse(0);
            int precision = Optional.ofNullable((String)schema.parameters().get(PRECISION_PARAMETER_KEY)).map(Integer::parseInt).orElse(20);
            if (precision > 38) {
                return DataTypes.STRING();
            }
            return DataTypes.DECIMAL((int)precision, (int)scale);
        }
        return DataTypes.BYTES();
    }

    protected DataType inferStruct(Object value, Schema schema) {
        Struct struct = (Struct)value;
        if ("io.debezium.data.VariableScaleDecimal".equals(schema.name())) {
            SpecialValueDecimal decimal = VariableScaleDecimal.toLogical((Struct)struct);
            BigDecimal bigDecimal = decimal.getDecimalValue().orElse(BigDecimal.ZERO);
            return DataTypes.DECIMAL((int)bigDecimal.precision(), (int)bigDecimal.scale());
        }
        return DataTypes.ROW((DataField[])((DataField[])schema.fields().stream().map(f -> DataTypes.FIELD((String)f.name(), (DataType)this.infer(struct.get(f.name()), f.schema()))).toArray(DataField[]::new)));
    }

    protected DataType inferArray(Object value, Schema schema) {
        throw new UnsupportedOperationException("Unsupported type ARRAY");
    }

    protected DataType inferMap(Object value, Schema schema) {
        throw new UnsupportedOperationException("Unsupported type MAP");
    }
}

