/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.adapt.jts.model;

import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;

public class JtsLayer {
    private final String name;
    private final Collection<Geometry> geometries;

    public JtsLayer(String name) {
        this(name, new ArrayList<Geometry>(0));
    }

    public JtsLayer(String name, Collection<Geometry> geometries) {
        JtsLayer.validate(name, geometries);
        this.name = name;
        this.geometries = geometries;
    }

    public Collection<Geometry> getGeometries() {
        return this.geometries;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsLayer layer = (JtsLayer)o;
        if (this.name != null ? !this.name.equals(layer.name) : layer.name != null) {
            return false;
        }
        return this.geometries != null ? this.geometries.equals(layer.geometries) : layer.geometries == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.geometries != null ? this.geometries.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Layer{name='" + this.name + '\'' + ", geometries=" + this.geometries + '}';
    }

    private static void validate(String name, Collection<Geometry> geometries) {
        if (name == null) {
            throw new IllegalArgumentException("layer name is null");
        }
        if (geometries == null) {
            throw new IllegalArgumentException("geometry collection is null");
        }
    }
}

