/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.date;

import com.xiaoleilu.hutool.date.BetweenFormater;
import com.xiaoleilu.hutool.date.DateUnit;
import com.xiaoleilu.hutool.date.DateUtil;
import java.util.Calendar;
import java.util.Date;

public class DateBetween {
    private Date begin;
    private Date end;

    public DateBetween(Date begin, Date end) {
        if (begin.before(end)) {
            this.begin = begin;
            this.end = end;
        } else {
            this.begin = end;
            this.end = begin;
        }
    }

    public long between(DateUnit unit) {
        long diff = this.end.getTime() - this.begin.getTime();
        return diff / unit.getMillis();
    }

    public long betweenMonth(boolean isReset) {
        Calendar beginCal = DateUtil.calendar(this.begin);
        Calendar endCal = DateUtil.calendar(this.end);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (isReset && beginCal.get(5) > endCal.get(5)) {
            return result - 1;
        }
        return result;
    }

    public long betweenYear(boolean isReset) {
        Calendar beginCal = DateUtil.calendar(this.begin);
        Calendar endCal = DateUtil.calendar(this.end);
        int result = endCal.get(1) - beginCal.get(1);
        if (isReset && beginCal.get(2) > endCal.get(2)) {
            return result - 1;
        }
        return result;
    }

    public String toString(BetweenFormater.Level level) {
        return DateUtil.formatBetween(this.between(DateUnit.MS), level);
    }

    public String toString() {
        return this.toString(BetweenFormater.Level.MILLSECOND);
    }
}

