/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.biz.model.TriggerParam;
import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.log.XxlJobFileAppender;
import com.xxl.job.core.thread.TriggerCallbackThread;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(JobThread.class);
    private int jobId;
    private IJobHandler handler;
    private LinkedBlockingQueue<TriggerParam> triggerQueue;
    private Set<Long> triggerLogIdSet;
    private volatile boolean toStop = false;
    private String stopReason;
    private boolean running = false;
    private int idleTimes = 0;

    public JobThread(int jobId, IJobHandler handler) {
        this.jobId = jobId;
        this.handler = handler;
        this.triggerQueue = new LinkedBlockingQueue();
        this.triggerLogIdSet = Collections.synchronizedSet(new HashSet());
    }

    public IJobHandler getHandler() {
        return this.handler;
    }

    public ReturnT<String> pushTriggerQueue(TriggerParam triggerParam) {
        if (this.triggerLogIdSet.contains(triggerParam.getLogId())) {
            logger.info(">>>>>>>>>>> repeate trigger job, logId:{}", (Object)triggerParam.getLogId());
            return new ReturnT<String>(500, "repeate trigger job, logId:" + triggerParam.getLogId());
        }
        this.triggerLogIdSet.add(triggerParam.getLogId());
        this.triggerQueue.add(triggerParam);
        return ReturnT.SUCCESS;
    }

    public void toStop(String stopReason) {
        this.toStop = true;
        this.stopReason = stopReason;
    }

    public boolean isRunningOrHasQueue() {
        return this.running || this.triggerQueue.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TriggerParam triggerParam;
        try {
            this.handler.init();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        while (!this.toStop) {
            this.running = false;
            ++this.idleTimes;
            triggerParam = null;
            try {
                triggerParam = this.triggerQueue.poll(3L, TimeUnit.SECONDS);
                if (triggerParam != null) {
                    this.running = true;
                    this.idleTimes = 0;
                    this.triggerLogIdSet.remove(triggerParam.getLogId());
                    String logFileName = XxlJobFileAppender.makeLogFileName(new Date(triggerParam.getLogDateTime()), triggerParam.getLogId());
                    final XxlJobContext xxlJobContext = new XxlJobContext(triggerParam.getJobId(), triggerParam.getExecutorParams(), logFileName, triggerParam.getBroadcastIndex(), triggerParam.getBroadcastTotal());
                    XxlJobContext.setXxlJobContext(xxlJobContext);
                    XxlJobHelper.log("<br>----------- xxl-job job execute start -----------<br>----------- Param:" + xxlJobContext.getJobParam(), new Object[0]);
                    if (triggerParam.getExecutorTimeout() > 0) {
                        Thread futureThread = null;
                        try {
                            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

                                @Override
                                public Boolean call() throws Exception {
                                    XxlJobContext.setXxlJobContext(xxlJobContext);
                                    JobThread.this.handler.execute();
                                    return true;
                                }
                            });
                            futureThread = new Thread(futureTask);
                            futureThread.start();
                            Boolean bl = futureTask.get(triggerParam.getExecutorTimeout(), TimeUnit.SECONDS);
                        }
                        catch (TimeoutException e) {
                            XxlJobHelper.log("<br>----------- xxl-job job execute timeout", new Object[0]);
                            XxlJobHelper.log(e);
                            XxlJobHelper.handleTimeout("job execute timeout ");
                        }
                        finally {
                            futureThread.interrupt();
                        }
                    } else {
                        this.handler.execute();
                    }
                    if (XxlJobContext.getXxlJobContext().getHandleCode() <= 0) {
                        XxlJobHelper.handleFail("job handle result lost.");
                    } else {
                        String tempHandleMsg = XxlJobContext.getXxlJobContext().getHandleMsg();
                        tempHandleMsg = tempHandleMsg != null && tempHandleMsg.length() > 50000 ? tempHandleMsg.substring(0, 50000).concat("...") : tempHandleMsg;
                        XxlJobContext.getXxlJobContext().setHandleMsg(tempHandleMsg);
                    }
                    XxlJobHelper.log("<br>----------- xxl-job job execute end(finish) -----------<br>----------- Result: handleCode=" + XxlJobContext.getXxlJobContext().getHandleCode() + ", handleMsg = " + XxlJobContext.getXxlJobContext().getHandleMsg(), new Object[0]);
                    continue;
                }
                if (this.idleTimes <= 30 || this.triggerQueue.size() != 0) continue;
                XxlJobExecutor.removeJobThread(this.jobId, "excutor idel times over limit.");
            }
            catch (Throwable e) {
                if (this.toStop) {
                    XxlJobHelper.log("<br>----------- JobThread toStop, stopReason:" + this.stopReason, new Object[0]);
                }
                StringWriter stringWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(stringWriter));
                String errorMsg = stringWriter.toString();
                XxlJobHelper.handleFail(errorMsg);
                XxlJobHelper.log("<br>----------- JobThread Exception:" + errorMsg + "<br>----------- xxl-job job execute end(error) -----------", new Object[0]);
            }
            finally {
                if (triggerParam == null) continue;
                if (!this.toStop) {
                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTime(), XxlJobContext.getXxlJobContext().getHandleCode(), XxlJobContext.getXxlJobContext().getHandleMsg()));
                    continue;
                }
                TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTime(), 500, this.stopReason + " [job running, killed]"));
            }
        }
        while (this.triggerQueue != null && this.triggerQueue.size() > 0) {
            triggerParam = this.triggerQueue.poll();
            if (triggerParam == null) continue;
            TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), triggerParam.getLogDateTime(), 500, this.stopReason + " [job not executed, in the job queue, killed.]"));
        }
        try {
            this.handler.destroy();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        logger.info(">>>>>>>>>>> xxl-job JobThread stoped, hashCode:{}", (Object)Thread.currentThread());
    }
}

