/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.invoker.reference;

import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.invoker.call.CallType;
import com.xxl.rpc.remoting.invoker.call.XxlRpcInvokeCallback;
import com.xxl.rpc.remoting.invoker.call.XxlRpcInvokeFuture;
import com.xxl.rpc.remoting.net.Client;
import com.xxl.rpc.remoting.net.NetEnum;
import com.xxl.rpc.remoting.net.params.XxlRpcFutureResponse;
import com.xxl.rpc.remoting.net.params.XxlRpcFutureResponseFactory;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.XxlRpcException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlRpcReferenceBean {
    private static final Logger logger = LoggerFactory.getLogger(XxlRpcReferenceBean.class);
    private NetEnum netType;
    private Serializer serializer;
    private CallType callType;
    private Class<?> iface;
    private String version;
    private long timeout;
    private String address;
    private String accessToken;
    private XxlRpcInvokeCallback invokeCallback;
    Client client = null;

    public XxlRpcReferenceBean(NetEnum netType, Serializer serializer, CallType callType, Class<?> iface, String version, long timeout, String address, String accessToken, XxlRpcInvokeCallback invokeCallback) {
        this.netType = netType;
        this.serializer = serializer;
        this.callType = callType;
        this.iface = iface;
        this.version = version;
        this.timeout = timeout;
        this.address = address;
        this.accessToken = accessToken;
        this.invokeCallback = invokeCallback;
        this.initClient();
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public long getTimeout() {
        return this.timeout;
    }

    private void initClient() {
        try {
            this.client = this.netType.clientClass.newInstance();
            this.client.init(this);
        }
        catch (Exception e) {
            throw new XxlRpcException(e);
        }
    }

    public String routeAddress() {
        String addressItem = this.address;
        if (addressItem != null && addressItem.trim().length() > 0) {
            return addressItem;
        }
        if (XxlRpcInvokerFactory.getServiceRegistry() != null) {
            String serviceKey = XxlRpcProviderFactory.makeServiceKey(this.iface.getName(), this.version);
            TreeSet<String> addressSet = XxlRpcInvokerFactory.getServiceRegistry().discovery(serviceKey);
            if (addressSet.size() > 0) {
                addressItem = new ArrayList<String>(addressSet).get(new Random().nextInt(addressSet.size()));
            }
        }
        return addressItem;
    }

    public Object getObject() {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.iface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String className = method.getDeclaringClass().getName();
                if (Object.class.getName().equals(className)) {
                    logger.info(">>>>>>>>>>> xxl-rpc proxy class-method not support [{}.{}]", (Object)className, (Object)method.getName());
                    throw new XxlRpcException("xxl-rpc proxy class-method not support");
                }
                String address = XxlRpcReferenceBean.this.routeAddress();
                if (address == null || address.trim().length() == 0) {
                    throw new XxlRpcException("xxl-rpc reference bean[" + className + "] address empty");
                }
                XxlRpcRequest xxlRpcRequest = new XxlRpcRequest();
                xxlRpcRequest.setRequestId(UUID.randomUUID().toString());
                xxlRpcRequest.setCreateMillisTime(System.currentTimeMillis());
                xxlRpcRequest.setAccessToken(XxlRpcReferenceBean.this.accessToken);
                xxlRpcRequest.setClassName(className);
                xxlRpcRequest.setMethodName(method.getName());
                xxlRpcRequest.setParameterTypes(method.getParameterTypes());
                xxlRpcRequest.setParameters(args);
                if (CallType.SYNC == XxlRpcReferenceBean.this.callType) {
                    try {
                        XxlRpcFutureResponse futureResponse = new XxlRpcFutureResponse(xxlRpcRequest, null);
                        XxlRpcFutureResponseFactory.setInvokerFuture(xxlRpcRequest.getRequestId(), futureResponse);
                        XxlRpcReferenceBean.this.client.asyncSend(address, xxlRpcRequest);
                        XxlRpcResponse xxlRpcResponse = futureResponse.get(XxlRpcReferenceBean.this.timeout, TimeUnit.MILLISECONDS);
                        if (xxlRpcResponse.getErrorMsg() != null) {
                            throw new XxlRpcException(xxlRpcResponse.getErrorMsg());
                        }
                        Object object = xxlRpcResponse.getResult();
                        return object;
                    }
                    catch (Exception e) {
                        throw new XxlRpcException(e);
                    }
                    finally {
                        XxlRpcFutureResponseFactory.removeInvokerFuture(xxlRpcRequest.getRequestId());
                    }
                }
                if (CallType.FUTURE == XxlRpcReferenceBean.this.callType) {
                    XxlRpcInvokeFuture invokeFuture = null;
                    try {
                        invokeFuture = new XxlRpcInvokeFuture(new XxlRpcFutureResponse(xxlRpcRequest, null));
                        XxlRpcInvokeFuture.setFuture(invokeFuture);
                        XxlRpcReferenceBean.this.client.asyncSend(address, xxlRpcRequest);
                        return null;
                    }
                    catch (Exception e) {
                        invokeFuture.stop();
                        throw new XxlRpcException(e);
                    }
                }
                if (CallType.CALLBACK == XxlRpcReferenceBean.this.callType) {
                    XxlRpcInvokeCallback finalInvokeCallback = XxlRpcReferenceBean.this.invokeCallback;
                    XxlRpcInvokeCallback threadInvokeCallback = XxlRpcInvokeCallback.getCallback();
                    if (threadInvokeCallback != null) {
                        finalInvokeCallback = threadInvokeCallback;
                    }
                    if (finalInvokeCallback == null) {
                        throw new XxlRpcException("xxl-rpc XxlRpcInvokeCallback\uff08CallType=" + CallType.CALLBACK.name() + "\uff09 cannot be null.");
                    }
                    try {
                        XxlRpcFutureResponse futureResponse = new XxlRpcFutureResponse(xxlRpcRequest, finalInvokeCallback);
                        XxlRpcFutureResponseFactory.setInvokerFuture(xxlRpcRequest.getRequestId(), futureResponse);
                        XxlRpcReferenceBean.this.client.asyncSend(address, xxlRpcRequest);
                    }
                    catch (Exception e) {
                        XxlRpcFutureResponseFactory.removeInvokerFuture(xxlRpcRequest.getRequestId());
                        throw new XxlRpcException(e);
                    }
                    return null;
                }
                if (CallType.ONEWAY == XxlRpcReferenceBean.this.callType) {
                    XxlRpcReferenceBean.this.client.asyncSend(address, xxlRpcRequest);
                    return null;
                }
                throw new XxlRpcException("xxl-rpc callType[" + (Object)((Object)XxlRpcReferenceBean.this.callType) + "] invalid");
            }
        });
    }

    public Class<?> getObjectType() {
        return this.iface;
    }
}

