/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.jetty.server;

import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.util.XxlRpcException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServerHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(JettyServerHandler.class);
    private XxlRpcProviderFactory xxlRpcProviderFactory;

    public JettyServerHandler(XxlRpcProviderFactory xxlRpcProviderFactory) {
        this.xxlRpcProviderFactory = xxlRpcProviderFactory;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        XxlRpcRequest xxlRpcRequest = this.parseRequest(request);
        XxlRpcResponse xxlRpcResponse = this.xxlRpcProviderFactory.invokeService(xxlRpcRequest);
        this.writeResponse(baseRequest, response, xxlRpcResponse);
    }

    private void writeResponse(Request baseRequest, HttpServletResponse response, XxlRpcResponse xxlRpcResponse) throws IOException {
        byte[] responseBytes = this.xxlRpcProviderFactory.getSerializer().serialize(xxlRpcResponse);
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        baseRequest.setHandled(true);
        ServletOutputStream out = response.getOutputStream();
        out.write(responseBytes);
        out.flush();
    }

    private XxlRpcRequest parseRequest(HttpServletRequest request) throws IOException {
        byte[] requestBytes = JettyServerHandler.readBytes(request);
        if (requestBytes == null || requestBytes.length == 0) {
            throw new XxlRpcException("XxlRpcRequest byte[] is null");
        }
        XxlRpcRequest rpcXxlRpcRequest = (XxlRpcRequest)this.xxlRpcProviderFactory.getSerializer().deserialize(requestBytes, XxlRpcRequest.class);
        return rpcXxlRpcRequest;
    }

    public static final byte[] readBytes(HttpServletRequest request) throws IOException {
        request.setCharacterEncoding("UTF-8");
        int contentLen = request.getContentLength();
        ServletInputStream is = request.getInputStream();
        if (contentLen > 0) {
            int readLengthThisTime = 0;
            byte[] message = new byte[contentLen];
            try {
                for (int readLen = 0; readLen != contentLen && (readLengthThisTime = is.read(message, readLen, contentLen - readLen)) != -1; readLen += readLengthThisTime) {
                }
                return message;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new byte[0];
    }
}

