/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.serialize.impl;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.XxlRpcException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HessianSerializer
extends Serializer {
    @Override
    public <T> byte[] serialize(T obj) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Hessian2Output ho = new Hessian2Output((OutputStream)os);
        try {
            byte[] result;
            ho.writeObject(obj);
            ho.flush();
            byte[] byArray = result = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new XxlRpcException(e.getMessage(), e);
        }
        finally {
            try {
                ho.close();
            }
            catch (IOException e) {
                throw new XxlRpcException(e.getMessage(), e);
            }
            try {
                os.close();
            }
            catch (IOException e) {
                throw new XxlRpcException(e.getMessage(), e);
            }
        }
    }

    @Override
    public <T> Object deserialize(byte[] bytes, Class<T> clazz) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Hessian2Input hi = new Hessian2Input((InputStream)is);
        try {
            Object result;
            Object object = result = hi.readObject();
            return object;
        }
        catch (IOException e) {
            throw new XxlRpcException(e.getMessage(), e);
        }
        finally {
            try {
                hi.close();
            }
            catch (Exception e) {
                throw new XxlRpcException(e.getMessage(), e);
            }
            try {
                is.close();
            }
            catch (IOException e) {
                throw new XxlRpcException(e.getMessage(), e);
            }
        }
    }
}

