/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.serialize.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.XxlRpcException;
import java.io.IOException;

public class JacksonSerializer
extends Serializer {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public <T> byte[] serialize(T obj) {
        try {
            return objectMapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new XxlRpcException(e.getMessage(), e);
        }
    }

    @Override
    public <T> Object deserialize(byte[] bytes, Class<T> clazz) {
        try {
            return objectMapper.readValue(bytes, clazz);
        }
        catch (JsonParseException e) {
            throw new XxlRpcException(e.getMessage(), e);
        }
        catch (JsonMappingException e) {
            throw new XxlRpcException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XxlRpcException(e.getMessage(), e);
        }
    }
}

