/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.serialize.impl;

import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.XxlRpcException;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ProtostuffSerializer
extends Serializer {
    private static Objenesis objenesis = new ObjenesisStd(true);
    private static Map<Class<?>, Schema<?>> cachedSchema = new ConcurrentHashMap();

    private static <T> Schema<T> getSchema(Class<T> cls) {
        RuntimeSchema schema = cachedSchema.get(cls);
        if (schema == null && (schema = RuntimeSchema.createFrom(cls)) != null) {
            cachedSchema.put(cls, (Schema<?>)schema);
        }
        return schema;
    }

    @Override
    public <T> byte[] serialize(T obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = ProtostuffSerializer.getSchema(cls);
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw new XxlRpcException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }

    @Override
    public <T> Object deserialize(byte[] bytes, Class<T> clazz) {
        try {
            Object message = objenesis.newInstance(clazz);
            Schema<T> schema = ProtostuffSerializer.getSchema(clazz);
            ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)message, schema);
            return message;
        }
        catch (Exception e) {
            throw new XxlRpcException(e.getMessage(), e);
        }
    }
}

