/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.graaljs;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.script.ScriptBeanManager;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.script.ScriptExecutor;
import com.yomahub.liteflow.script.exception.ScriptLoadException;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.util.CopyOnWriteHashMap;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalJavaScriptExecutor
implements ScriptExecutor {
    private final Map<String, Source> scriptMap = new CopyOnWriteHashMap();
    private Engine engine;

    public ScriptExecutor init() {
        this.engine = Engine.create();
        return this;
    }

    public void load(String nodeId, String script) {
        try {
            String wrapScript = StrUtil.format((CharSequence)"function process(){{}} process();", (Object[])new Object[]{script});
            this.scriptMap.put(nodeId, Source.create((String)"js", (CharSequence)wrapScript));
        }
        catch (Exception e) {
            String errorMsg = StrUtil.format((CharSequence)"script loading error for node[{}], error msg:{}", (Object[])new Object[]{nodeId, e.getMessage()});
            throw new ScriptLoadException(errorMsg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ScriptExecuteWrap wrap) throws Exception {
        if (!this.scriptMap.containsKey(wrap.getNodeId())) {
            String errorMsg = StrUtil.format((CharSequence)"script for node[{}] is not loaded", (Object[])new Object[]{wrap.getNodeId()});
            throw new ScriptLoadException(errorMsg);
        }
        try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).engine(this.engine).build();){
            Value bindings = context.getBindings("js");
            DataBus.getContextBeanList((int)wrap.getSlotIndex()).forEach(o -> {
                String key = StrUtil.lowerFirst((CharSequence)o.getClass().getSimpleName());
                bindings.putMember(key, o);
            });
            Map metaMap = BeanUtil.beanToMap((Object)wrap, (String[])new String[0]);
            Slot slot = DataBus.getSlot((int)wrap.getSlotIndex());
            metaMap.put("requestData", slot.getRequestData());
            Object subRequestData = slot.getChainReqData(wrap.getCurrChainId());
            if (ObjectUtil.isNotNull((Object)subRequestData)) {
                metaMap.put("subRequestData", subRequestData);
            }
            bindings.putMember("_meta", (Object)metaMap);
            ScriptBeanManager.getScriptBeanMap().forEach((key, value) -> {
                if (!bindings.hasMember(key)) {
                    bindings.putMember(key, value);
                }
            });
            Value value2 = context.eval(this.scriptMap.get(wrap.getNodeId()));
            if (value2.isBoolean()) {
                Boolean bl = value2.asBoolean();
                return bl;
            }
            if (value2.isNumber()) {
                Integer n = value2.asInt();
                return n;
            }
            if (value2.isString()) {
                String string = value2.asString();
                return string;
            }
            Value value3 = value2;
            return value3;
        }
    }

    public void cleanCache() {
        this.scriptMap.clear();
    }
}

