//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.6
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Ice;

/**
 * The Ice remote logger interface. An application can implement a
 * RemoteLogger to receive the log messages sent to the local {@link Logger}
 * of another Ice application.
 **/
public interface RemoteLoggerPrx extends ObjectPrx
{
    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     **/
    default void init(String prefix, LogMessage[] logMessages)
    {
        init(prefix, logMessages, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param context The Context map to send with the invocation.
     **/
    default void init(String prefix, LogMessage[] logMessages, java.util.Map<String, String> context)
    {
        _iceI_initAsync(prefix, logMessages, context, true).waitForResponse();
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> initAsync(String prefix, LogMessage[] logMessages)
    {
        return _iceI_initAsync(prefix, logMessages, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> initAsync(String prefix, LogMessage[] logMessages, java.util.Map<String, String> context)
    {
        return _iceI_initAsync(prefix, logMessages, context, false);
    }

    /**
     * @hidden
     * @param iceP_prefix -
     * @param iceP_logMessages -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_initAsync(String iceP_prefix, LogMessage[] iceP_logMessages, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "init", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeString(iceP_prefix);
                     LogMessageSeqHelper.write(ostr, iceP_logMessages);
                 }, null);
        return f;
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     **/
    default void log(LogMessage message)
    {
        log(message, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param context The Context map to send with the invocation.
     **/
    default void log(LogMessage message, java.util.Map<String, String> context)
    {
        _iceI_logAsync(message, context, true).waitForResponse();
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> logAsync(LogMessage message)
    {
        return _iceI_logAsync(message, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> logAsync(LogMessage message, java.util.Map<String, String> context)
    {
        return _iceI_logAsync(message, context, false);
    }

    /**
     * @hidden
     * @param iceP_message -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_logAsync(LogMessage iceP_message, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "log", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     LogMessage.ice_write(ostr, iceP_message);
                 }, null);
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RemoteLoggerPrx checkedCast(ObjectPrx obj)
    {
        return ObjectPrx._checkedCast(obj, ice_staticId(), RemoteLoggerPrx.class, _RemoteLoggerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RemoteLoggerPrx checkedCast(ObjectPrx obj, java.util.Map<String, String> context)
    {
        return ObjectPrx._checkedCast(obj, context, ice_staticId(), RemoteLoggerPrx.class, _RemoteLoggerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RemoteLoggerPrx checkedCast(ObjectPrx obj, String facet)
    {
        return ObjectPrx._checkedCast(obj, facet, ice_staticId(), RemoteLoggerPrx.class, _RemoteLoggerPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static RemoteLoggerPrx checkedCast(ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), RemoteLoggerPrx.class, _RemoteLoggerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static RemoteLoggerPrx uncheckedCast(ObjectPrx obj)
    {
        return ObjectPrx._uncheckedCast(obj, RemoteLoggerPrx.class, _RemoteLoggerPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static RemoteLoggerPrx uncheckedCast(ObjectPrx obj, String facet)
    {
        return ObjectPrx._uncheckedCast(obj, facet, RemoteLoggerPrx.class, _RemoteLoggerPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default RemoteLoggerPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (RemoteLoggerPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default RemoteLoggerPrx ice_adapterId(String newAdapterId)
    {
        return (RemoteLoggerPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default RemoteLoggerPrx ice_endpoints(Endpoint[] newEndpoints)
    {
        return (RemoteLoggerPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default RemoteLoggerPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (RemoteLoggerPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default RemoteLoggerPrx ice_invocationTimeout(int newTimeout)
    {
        return (RemoteLoggerPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default RemoteLoggerPrx ice_connectionCached(boolean newCache)
    {
        return (RemoteLoggerPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default RemoteLoggerPrx ice_endpointSelection(EndpointSelectionType newType)
    {
        return (RemoteLoggerPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default RemoteLoggerPrx ice_secure(boolean b)
    {
        return (RemoteLoggerPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default RemoteLoggerPrx ice_encodingVersion(EncodingVersion e)
    {
        return (RemoteLoggerPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default RemoteLoggerPrx ice_preferSecure(boolean b)
    {
        return (RemoteLoggerPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default RemoteLoggerPrx ice_router(RouterPrx router)
    {
        return (RemoteLoggerPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default RemoteLoggerPrx ice_locator(LocatorPrx locator)
    {
        return (RemoteLoggerPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default RemoteLoggerPrx ice_collocationOptimized(boolean b)
    {
        return (RemoteLoggerPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default RemoteLoggerPrx ice_twoway()
    {
        return (RemoteLoggerPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default RemoteLoggerPrx ice_oneway()
    {
        return (RemoteLoggerPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default RemoteLoggerPrx ice_batchOneway()
    {
        return (RemoteLoggerPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default RemoteLoggerPrx ice_datagram()
    {
        return (RemoteLoggerPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default RemoteLoggerPrx ice_batchDatagram()
    {
        return (RemoteLoggerPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default RemoteLoggerPrx ice_compress(boolean co)
    {
        return (RemoteLoggerPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default RemoteLoggerPrx ice_timeout(int t)
    {
        return (RemoteLoggerPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default RemoteLoggerPrx ice_connectionId(String connectionId)
    {
        return (RemoteLoggerPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default RemoteLoggerPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (RemoteLoggerPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::Ice::RemoteLogger";
    }
}
