/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client.reactive;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.web.client.reactive.ReactiveHttpHeadersProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

public class CompositeReactiveHttpHeadersProvider
implements ReactiveHttpHeadersProvider {
    private final Collection<ReactiveHttpHeadersProvider> delegates;

    public CompositeReactiveHttpHeadersProvider(Collection<ReactiveHttpHeadersProvider> delegates) {
        this.delegates = delegates;
    }

    @Override
    public Mono<HttpHeaders> getHeaders(Instance instance) {
        List<Mono> headers = this.delegates.stream().map(reactiveHttpHeadersProvider -> reactiveHttpHeadersProvider.getHeaders(instance)).toList();
        return Mono.zip(headers, this::mergeMonosToHeaders);
    }

    private HttpHeaders mergeMonosToHeaders(Object[] e) {
        return Arrays.stream(e).map(HttpHeaders.class::cast).reduce(new HttpHeaders(), (h1, h2) -> {
            h1.addAll((MultiValueMap)h2);
            return h1;
        });
    }
}

