/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import jsyntaxpane.Lexer;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxView;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.JarServiceProvider;

public class DefaultSyntaxKit
extends DefaultEditorKit
implements ViewFactory {
    public static final String CONFIG_CARETCOLOR = "CaretColor";
    public static final String CONFIG_SELECTION = "SelectionColor";
    public static final String CONFIG_COMPONENTS = "Components";
    public static final String CONFIG_MENU = "PopupMenu";
    public static final String CONFIG_TOOLBAR = "Toolbar";
    public static final String CONFIG_TOOLBAR_ROLLOVER = "Toolbar.Buttons.Rollover";
    public static final String CONFIG_TOOLBAR_BORDER = "Toolbar.Buttons.BorderPainted";
    public static final String CONFIG_TOOLBAR_OPAQUE = "Toolbar.Buttons.Opaque";
    public static final String CONFIG_TOOLBAR_BORDER_SIZE = "Toolbar.Buttons.BorderSize";
    private static final Pattern ACTION_KEY_PATTERN;
    private static final Pattern DEFAULT_ACTION_PATTERN;
    private static Font DEFAULT_FONT;
    private static Set<String> CONTENT_TYPES;
    private static Boolean initialized;
    private static Map<String, String> abbrvs;
    private static String MENU_MASK_STRING;
    private Lexer lexer;
    private static final Logger LOG;
    private Map<JEditorPane, List<SyntaxComponent>> editorComponents = new WeakHashMap<JEditorPane, List<SyntaxComponent>>();
    private Map<JEditorPane, JPopupMenu> popupMenu = new WeakHashMap<JEditorPane, JPopupMenu>();
    private static Map<Class<? extends DefaultSyntaxKit>, Configuration> CONFIGS;
    private static final String ACTION_MENU_TEXT = "MenuText";

    public DefaultSyntaxKit(Lexer lexer) {
        this.lexer = lexer;
    }

    public void addComponents(JEditorPane jEditorPane) {
        String[] stringArray;
        for (String string : stringArray = this.getConfig().getPropertyList(CONFIG_COMPONENTS)) {
            this.installComponent(jEditorPane, string);
        }
    }

    public void installComponent(JEditorPane jEditorPane, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            SyntaxComponent syntaxComponent = (SyntaxComponent)clazz.newInstance();
            syntaxComponent.config(this.getConfig());
            syntaxComponent.install(jEditorPane);
            if (this.editorComponents.get(jEditorPane) == null) {
                this.editorComponents.put(jEditorPane, new ArrayList());
            }
            this.editorComponents.get(jEditorPane).add(syntaxComponent);
        }
        catch (InstantiationException instantiationException) {
            LOG.log(Level.SEVERE, null, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.log(Level.SEVERE, null, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.SEVERE, null, classNotFoundException);
        }
    }

    public void deinstallComponent(JEditorPane jEditorPane, String string) {
        for (SyntaxComponent syntaxComponent : this.editorComponents.get(jEditorPane)) {
            if (!syntaxComponent.getClass().getName().equals(string)) continue;
            syntaxComponent.deinstall(jEditorPane);
            this.editorComponents.get(jEditorPane).remove(syntaxComponent);
            break;
        }
    }

    public boolean isComponentInstalled(JEditorPane jEditorPane, String string) {
        for (SyntaxComponent syntaxComponent : this.editorComponents.get(jEditorPane)) {
            if (!syntaxComponent.getClass().getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean toggleComponent(JEditorPane jEditorPane, String string) {
        for (SyntaxComponent syntaxComponent : this.editorComponents.get(jEditorPane)) {
            if (!syntaxComponent.getClass().getName().equals(string)) continue;
            syntaxComponent.deinstall(jEditorPane);
            this.editorComponents.get(jEditorPane).remove(syntaxComponent);
            return false;
        }
        this.installComponent(jEditorPane, string);
        return true;
    }

    public void addPopupMenu(JEditorPane jEditorPane) {
        String[] stringArray = this.getConfig().getPropertyList(CONFIG_MENU);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.popupMenu.put(jEditorPane, new JPopupMenu());
        Object object = null;
        for (String string : stringArray) {
            JMenuItem jMenuItem;
            Object object2;
            if (string.equals("-")) {
                this.popupMenu.get(jEditorPane).addSeparator();
                continue;
            }
            if (string.startsWith(">")) {
                object2 = new JMenu(string.substring(1));
                this.popupMenu.get(jEditorPane).add((JMenuItem)object2);
                object = object2;
                continue;
            }
            if (string.startsWith("<")) {
                object2 = ((Component)object).getParent();
                if (object2 instanceof JMenu) {
                    jMenuItem = (JMenu)object2;
                    object = jMenuItem;
                    continue;
                }
                object = null;
                continue;
            }
            object2 = jEditorPane.getActionMap().get(string);
            if (object2 == null) continue;
            jMenuItem = object2.getValue("SwingSelectedKey") != null ? new JCheckBoxMenuItem((Action)object2) : new JMenuItem((Action)object2);
            if (object2.getValue(ACTION_MENU_TEXT) != null) {
                jMenuItem.setText((String)object2.getValue(ACTION_MENU_TEXT));
            }
            if (object == null) {
                this.popupMenu.get(jEditorPane).add(jMenuItem);
                continue;
            }
            ((JMenu)object).add(jMenuItem);
        }
        jEditorPane.setComponentPopupMenu(this.popupMenu.get(jEditorPane));
    }

    public void addToolBarActions(JEditorPane jEditorPane, JToolBar jToolBar) {
        String[] stringArray = this.getConfig().getPropertyList(CONFIG_TOOLBAR);
        if (!(stringArray != null && stringArray.length != 0 || (stringArray = this.getConfig().getPropertyList(CONFIG_MENU)) != null && stringArray.length != 0)) {
            return;
        }
        boolean bl = this.getConfig().getBoolean(CONFIG_TOOLBAR_ROLLOVER, true);
        boolean bl2 = this.getConfig().getBoolean(CONFIG_TOOLBAR_BORDER, false);
        boolean bl3 = this.getConfig().getBoolean(CONFIG_TOOLBAR_OPAQUE, false);
        int n = this.getConfig().getInteger(CONFIG_TOOLBAR_BORDER_SIZE, 2);
        for (String string : stringArray) {
            if (string.equals("-") || string.startsWith("<") || string.startsWith(">")) {
                jToolBar.addSeparator();
                continue;
            }
            Action action = jEditorPane.getActionMap().get(string);
            if (action == null || action.getValue("SmallIcon") == null) continue;
            JButton jButton = jToolBar.add(action);
            jButton.setRolloverEnabled(bl);
            jButton.setBorderPainted(bl2);
            jButton.setOpaque(bl3);
            jButton.setFocusable(false);
            jButton.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element element) {
        return new SyntaxView(element, this.getConfig());
    }

    @Override
    public void install(JEditorPane jEditorPane) {
        super.install(jEditorPane);
        String string = this.getProperty("DefaultFont");
        Font font = DEFAULT_FONT;
        if (string != null) {
            font = Font.decode(string);
        }
        jEditorPane.setFont(font);
        Configuration configuration = this.getConfig();
        Color color = configuration.getColor(CONFIG_CARETCOLOR, Color.BLACK);
        jEditorPane.setCaretColor(color);
        Color color2 = this.getConfig().getColor(CONFIG_SELECTION, new Color(0x99CCFF));
        jEditorPane.setSelectionColor(color2);
        this.addActions(jEditorPane);
        this.addComponents(jEditorPane);
        this.addPopupMenu(jEditorPane);
    }

    @Override
    public void deinstall(JEditorPane jEditorPane) {
        List<SyntaxComponent> list = this.editorComponents.get(jEditorPane);
        for (SyntaxComponent syntaxComponent : this.editorComponents.get(jEditorPane)) {
            syntaxComponent.deinstall(jEditorPane);
        }
        this.editorComponents.clear();
        jEditorPane.getInputMap().clear();
        jEditorPane.getActionMap().clear();
    }

    public void addActions(JEditorPane jEditorPane) {
        Object object;
        Object object2;
        InputMap inputMap = new InputMap();
        inputMap.setParent(jEditorPane.getInputMap());
        ActionMap actionMap = new ActionMap();
        actionMap.setParent(jEditorPane.getActionMap());
        for (Configuration.StringKeyMatcher stringKeyMatcher : this.getConfig().getKeys(ACTION_KEY_PATTERN)) {
            object2 = Configuration.COMMA_SEPARATOR.split(stringKeyMatcher.value);
            object = object2[0];
            String string = stringKeyMatcher.group1;
            SyntaxAction syntaxAction = this.createAction((String)object);
            syntaxAction.config(this.getConfig(), "Action." + string);
            actionMap.put(string, syntaxAction);
            for (int i = 1; i < ((String[])object2).length; ++i) {
                String string2 = object2[i].replace("menu ", MENU_MASK_STRING);
                KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
                if (keyStroke == null) {
                    throw new IllegalArgumentException("Invalid KeyStroke: " + string2);
                }
                syntaxAction.putValue("AcceleratorKey", keyStroke);
                inputMap.put(keyStroke, string);
            }
        }
        for (Configuration.StringKeyMatcher stringKeyMatcher : this.getConfig().getKeys(DEFAULT_ACTION_PATTERN)) {
            object2 = stringKeyMatcher.matcher.group(2);
            object = jEditorPane.getActionMap().get(object2);
            if (object == null) continue;
            this.configActionProperties((Action)object, (String)object2, stringKeyMatcher.group1);
        }
        jEditorPane.setActionMap(actionMap);
        jEditorPane.setInputMap(0, inputMap);
    }

    private void configActionProperties(Action action, String string, String string2) {
        Object object;
        String string3 = this.getConfig().getString(string2 + ".SmallIcon", string + ".png");
        URL uRL = this.getClass().getResource("/META-INF/images/small-icons/" + string3);
        if (uRL != null) {
            object = new ImageIcon(uRL);
            action.putValue("SmallIcon", object);
        }
        object = this.getProperty(string2 + ".MenuText");
        if (action.getValue("Name") == null) {
            action.putValue("Name", object);
        } else {
            action.putValue(ACTION_MENU_TEXT, object);
        }
        String string4 = this.getProperty(string2 + ".ToolTip");
        if (string4 != null) {
            action.putValue("ShortDescription", string4);
        } else {
            action.putValue("ShortDescription", object);
        }
    }

    private SyntaxAction createAction(String string) {
        SyntaxAction syntaxAction = null;
        try {
            Class<?> clazz = Class.forName(string);
            syntaxAction = (SyntaxAction)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Cannot create action class: " + string + ". Ensure it has default constructor.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Cannot create action class: " + string, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Cannot create action class: " + string, classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Cannot create action class: " + string, classCastException);
        }
        return syntaxAction;
    }

    @Override
    public Document createDefaultDocument() {
        return new SyntaxDocument(this.lexer);
    }

    public static synchronized void initKit() {
        Object object;
        String string = DefaultSyntaxKit.getConfig(DefaultSyntaxKit.class).getString("DefaultFont");
        if (string != null) {
            DEFAULT_FONT = Font.decode(string);
        } else {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] stringArray = ((GraphicsEnvironment)object).getAvailableFontFamilyNames();
            Arrays.sort(stringArray);
            if (Arrays.binarySearch(stringArray, "Courier New") >= 0) {
                DEFAULT_FONT = new Font("Courier New", 0, 12);
            } else if (Arrays.binarySearch(stringArray, "Courier") >= 0) {
                DEFAULT_FONT = new Font("Courier", 0, 12);
            } else if (Arrays.binarySearch(stringArray, "Monospaced") >= 0) {
                DEFAULT_FONT = new Font("Monospaced", 0, 13);
            }
        }
        object = JarServiceProvider.readProperties("jsyntaxpane/kitsfortypes");
        for (Map.Entry entry : ((Properties)object).entrySet()) {
            String string2 = entry.getKey().toString();
            String string3 = entry.getValue().toString();
            DefaultSyntaxKit.registerContentType(string2, string3);
        }
        initialized = true;
    }

    public static void registerContentType(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            Object obj = clazz.newInstance();
            if (!(obj instanceof EditorKit)) {
                throw new IllegalArgumentException("Cannot register class: " + string2 + ". It does not extend EditorKit");
            }
            JEditorPane.registerEditorKitForContentType(string, string2);
            CONTENT_TYPES.add(string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Cannot register class: " + string2 + ". Ensure it has Default Constructor.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Cannot register class: " + string2, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Cannot register class: " + string2, classNotFoundException);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Cannot register class: " + string2, runtimeException);
        }
    }

    public static String[] getContentTypes() {
        Object[] objectArray = CONTENT_TYPES.toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void setConfig(Properties properties) {
        this.getConfig().putAll((Map)properties);
    }

    public void setProperty(String string, String string2) {
        this.getConfig().put(string, string2);
    }

    public String getProperty(String string) {
        return this.getConfig().getString(string);
    }

    public Configuration getConfig() {
        return DefaultSyntaxKit.getConfig(this.getClass());
    }

    public static synchronized Configuration getConfig(Class<? extends DefaultSyntaxKit> clazz) {
        Object object;
        if (CONFIGS == null) {
            CONFIGS = new WeakHashMap<Class<? extends DefaultSyntaxKit>, Configuration>();
            object = new Configuration(DefaultSyntaxKit.class);
            DefaultSyntaxKit.loadConfig((Configuration)object, DefaultSyntaxKit.class);
            CONFIGS.put(DefaultSyntaxKit.class, (Configuration)object);
        }
        if (CONFIGS.containsKey(clazz)) {
            return CONFIGS.get(clazz);
        }
        object = clazz.getSuperclass();
        Configuration configuration = DefaultSyntaxKit.getConfig(object);
        Configuration configuration2 = new Configuration(clazz, configuration);
        DefaultSyntaxKit.loadConfig(configuration2, clazz);
        CONFIGS.put(clazz, configuration2);
        return configuration2;
    }

    public Map<String, String> getAbbreviations() {
        if (abbrvs == null) {
            String string = this.getClass().getName().replace('.', '/').toLowerCase();
            abbrvs = JarServiceProvider.readStringsMap(string + "/abbreviations.properties");
        }
        return abbrvs;
    }

    public static void addAbbreviation(String string, String string2) {
        if (abbrvs == null) {
            abbrvs = new HashMap<String, String>();
        }
        abbrvs.put(string, string2);
    }

    public static String getAbbreviation(String string) {
        return abbrvs == null ? null : abbrvs.get(string);
    }

    private static void loadConfig(Configuration configuration, Class<? extends EditorKit> clazz) {
        String string = clazz.getName().replace(".", "/") + "/config";
        Properties properties = JarServiceProvider.readProperties(string, Locale.getDefault());
        if (properties.size() == 0) {
            LOG.log(Level.INFO, "unable to load configuration for: {0} from: {1}.properties", new Object[]{clazz, string});
        } else {
            configuration.putAll((Map)properties);
        }
    }

    @Override
    public String getContentType() {
        return "text/" + this.getClass().getSimpleName().replace("SyntaxKit", "").toLowerCase();
    }

    static {
        int n;
        ACTION_KEY_PATTERN = Pattern.compile("Action\\.((\\w|-)+)");
        DEFAULT_ACTION_PATTERN = Pattern.compile("(DefaultAction.((\\w|-)+)).*");
        CONTENT_TYPES = new HashSet<String>();
        initialized = false;
        MENU_MASK_STRING = "control ";
        LOG = Logger.getLogger(DefaultSyntaxKit.class.getName());
        if (!initialized.booleanValue()) {
            DefaultSyntaxKit.initKit();
        }
        if ((n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 512) {
            MENU_MASK_STRING = "alt ";
        }
    }
}

