/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public final class SyntaxStyle {
    private Color color;
    private int fontStyle;

    public SyntaxStyle() {
    }

    public SyntaxStyle(Color color, boolean bl, boolean bl2) {
        this.color = color;
        this.setBold(bl);
        this.setItalic(bl2);
    }

    public SyntaxStyle(Color color, int n) {
        this.color = color;
        this.fontStyle = n;
    }

    public SyntaxStyle(String string) {
        String[] stringArray = string.split("\\s*,\\s*");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("style not correct format: " + string);
        }
        this.color = new Color(Integer.decode(stringArray[0]));
        this.fontStyle = Integer.decode(stringArray[1]);
    }

    public boolean isBold() {
        return (this.fontStyle & 1) != 0;
    }

    public void setBold(Boolean bl) {
        if (bl.booleanValue()) {
            this.fontStyle |= 1;
        } else {
            int n = -2;
            this.fontStyle &= n;
        }
    }

    public String getColorString() {
        return String.format("0x%06x", this.color.getRGB() & 0xFFFFFF);
    }

    public void setColorString(String string) {
        this.color = Color.decode(string);
    }

    public Boolean isItalic() {
        return (this.fontStyle & 2) != 0;
    }

    public void setItalic(Boolean bl) {
        this.fontStyle = bl.booleanValue() ? (this.fontStyle |= 2) : (this.fontStyle &= 0xFFFFFFFD);
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public Color getColor() {
        return this.color;
    }

    public int drawText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        graphics.setFont(graphics.getFont().deriveFont(this.getFontStyle()));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getAscent();
        int n5 = n4 + fontMetrics.getDescent();
        int n6 = Utilities.getTabbedTextWidth(segment, fontMetrics, 0, tabExpander, n3);
        int n7 = n - 1;
        int n8 = n2 - n4;
        int n9 = n6 + 2;
        int n10 = n5;
        if ((this.getFontStyle() & 0x10) != 0) {
            graphics.setColor(Color.decode("#EEEEEE"));
            graphics.fillRect(n7, n8, n9, n10);
        }
        graphics.setColor(this.getColor());
        n = Utilities.drawTabbedText(segment, n, n2, graphics, tabExpander, n3);
        if ((this.getFontStyle() & 8) != 0) {
            graphics.setColor(Color.RED);
            graphics.drawRect(n7, n8, n9, n10);
        }
        return n;
    }
}

