/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.EditorKit;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.CaretMonitor;

public class SyntaxTester
extends JFrame {
    private JComboBox jCmbLangs;
    private JEditorPane jEdtTest;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JLabel lblCaretPos;
    private JLabel lblToken;

    public SyntaxTester() {
        this.initComponents();
        this.jCmbLangs.setModel(new DefaultComboBoxModel<String>(DefaultSyntaxKit.getContentTypes()));
        this.jCmbLangs.setSelectedItem("text/java");
        new CaretMonitor(this.jEdtTest, this.lblCaretPos);
    }

    private void initComponents() {
        this.lblCaretPos = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEdtTest = new JEditorPane();
        this.lblToken = new JLabel();
        this.jCmbLangs = new JComboBox();
        this.jToolBar1 = new JToolBar();
        this.setDefaultCloseOperation(3);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jsyntaxpane/Bundle");
        this.setTitle(resourceBundle.getString("SyntaxTester.title"));
        this.lblCaretPos.setHorizontalAlignment(11);
        this.lblCaretPos.setText(resourceBundle.getString("SyntaxTester.lblCaretPos.text"));
        this.jEdtTest.setContentType(resourceBundle.getString("SyntaxTester.jEdtTest.contentType"));
        this.jEdtTest.setFont(new Font("Monospaced", 0, 13));
        this.jEdtTest.setCaretColor(new Color(153, 204, 255));
        this.jEdtTest.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SyntaxTester.this.jEdtTestCaretUpdate(caretEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jEdtTest);
        this.lblToken.setFont(new Font("Courier New", 0, 12));
        this.lblToken.setText(resourceBundle.getString("SyntaxTester.lblToken.text"));
        this.jCmbLangs.setMaximumRowCount(20);
        this.jCmbLangs.setFocusable(false);
        this.jCmbLangs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SyntaxTester.this.jCmbLangsItemStateChanged(itemEvent);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setFocusable(false);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jCmbLangs, -2, 135, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 441, Short.MAX_VALUE).addComponent(this.lblCaretPos, -2, 119, -2).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lblToken, -1, 221, Short.MAX_VALUE).addGap(484, 484, 484)).addComponent(this.jToolBar1, -1, 715, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 715, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 382, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblToken, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCaretPos, -1, 21, Short.MAX_VALUE).addComponent(this.jCmbLangs, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void jEdtTestCaretUpdate(CaretEvent caretEvent) {
        SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(this.jEdtTest);
        if (syntaxDocument != null) {
            Token token = syntaxDocument.getTokenAt(caretEvent.getDot());
            if (token != null) {
                CharSequence charSequence = token.getText(syntaxDocument);
                if (token.length > 40) {
                    charSequence = charSequence.subSequence(0, 40);
                }
                this.lblToken.setText(token.toString() + ": " + charSequence);
            } else {
                this.lblToken.setText(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("NO_TOKEN_AT_CURSOR"));
            }
        }
    }

    private void jCmbLangsItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = this.jCmbLangs.getSelectedItem().toString();
            String string2 = this.jEdtTest.getText();
            this.jEdtTest.setContentType(string);
            this.jToolBar1.removeAll();
            EditorKit editorKit = this.jEdtTest.getEditorKit();
            if (editorKit instanceof DefaultSyntaxKit) {
                DefaultSyntaxKit defaultSyntaxKit = (DefaultSyntaxKit)editorKit;
                defaultSyntaxKit.addToolBarActions(this.jEdtTest, this.jToolBar1);
            }
            this.jToolBar1.validate();
            try {
                this.jEdtTest.read(new StringReader(string2), (Object)string);
            }
            catch (IOException iOException) {
                Logger.getLogger(SyntaxTester.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
        this.jEdtTest.requestFocusInWindow();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSyntaxKit.initKit();
                    new SyntaxTester().setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(2);
                }
            }
        });
    }
}

