/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import jsyntaxpane.TokenType;

public class Token
implements Serializable,
Comparable {
    public final TokenType type;
    public final int start;
    public final int length;
    public final byte pairValue;
    public final short kind = 0;

    public Token(TokenType tokenType, int n, int n2) {
        this.type = tokenType;
        this.start = n;
        this.length = n2;
        this.pairValue = 0;
    }

    public Token(TokenType tokenType, int n, int n2, byte by) {
        this.type = tokenType;
        this.start = n;
        this.length = n2;
        this.pairValue = by;
    }

    public boolean equals(Object object) {
        if (object instanceof Object) {
            Token token = (Token)object;
            return this.start == token.start && this.length == token.length && this.type.equals((Object)token.type);
        }
        return false;
    }

    public int hashCode() {
        return this.start;
    }

    public String toString() {
        if (this.pairValue == 0) {
            return String.format("%s (%d, %d)", new Object[]{this.type, this.start, this.length});
        }
        return String.format("%s (%d, %d) (%d)", new Object[]{this.type, this.start, this.length, this.pairValue});
    }

    public int compareTo(Object object) {
        Token token = (Token)object;
        if (this.start != token.start) {
            return this.start - token.start;
        }
        if (this.length != token.length) {
            return this.length - token.length;
        }
        return this.type.compareTo(token.type);
    }

    public int end() {
        return this.start + this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getText(Document document) {
        Segment segment = new Segment();
        try {
            document.getText(this.start, this.length, segment);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(Token.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        finally {
            return segment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Document document) {
        String string = "";
        try {
            string = document.getText(this.start, this.length);
            return string;
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(Token.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        finally {
            return string;
        }
    }
}

