/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.io.Serializable;
import java.util.Comparator;
import jsyntaxpane.Token;

public class TokenComparators {
    public static final Comparator<Token> LONGEST_FIRST = new LongestFirst();
    public static final Comparator<Token> SHORTEST_FIRST = new ShortestFirst();

    private static class ShortestFirst
    implements Comparator<Token>,
    Serializable {
        private ShortestFirst() {
        }

        @Override
        public int compare(Token token, Token token2) {
            if (token.start != token2.start) {
                return token.start - token2.start;
            }
            if (token.length != token2.length) {
                return token.length - token2.length;
            }
            return token.type.compareTo(token2.type);
        }
    }

    private static class LongestFirst
    implements Comparator<Token>,
    Serializable {
        private LongestFirst() {
        }

        @Override
        public int compare(Token token, Token token2) {
            if (token.start != token2.start) {
                return token.start - token2.start;
            }
            if (token.length != token2.length) {
                return token2.length - token.length;
            }
            return token.type.compareTo(token2.type);
        }
    }
}

