/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.QuickFindDialog;
import jsyntaxpane.actions.gui.ReplaceDialog;

public class DocumentSearchData {
    private static final String PROPERTY_KEY = "SearchData";
    private Pattern pattern = null;
    private boolean wrap = true;
    private ReplaceDialog replaceDlg;
    private QuickFindDialog quickFindDlg;

    private DocumentSearchData() {
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String string, boolean bl, boolean bl2) throws PatternSyntaxException {
        if (string != null && string.length() > 0) {
            int n = bl ? 0 : 16;
            this.setPattern(Pattern.compile(string, n |= bl2 ? 2 : 0));
        } else {
            this.setPattern(null);
        }
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
    }

    public static DocumentSearchData getFromEditor(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        Object object = jTextComponent.getDocument().getProperty(PROPERTY_KEY);
        if (object instanceof DocumentSearchData) {
            DocumentSearchData documentSearchData = (DocumentSearchData)object;
            return documentSearchData;
        }
        DocumentSearchData documentSearchData = new DocumentSearchData();
        jTextComponent.getDocument().putProperty(PROPERTY_KEY, documentSearchData);
        return documentSearchData;
    }

    public void doReplaceAll(JTextComponent jTextComponent, String string) {
        SyntaxDocument syntaxDocument;
        if (string == null) {
            string = "";
        }
        if ((syntaxDocument = ActionUtils.getSyntaxDocument(jTextComponent)) == null) {
            return;
        }
        if (this.getPattern() == null) {
            return;
        }
        Matcher matcher = syntaxDocument.getMatcher(this.getPattern());
        String string2 = matcher.replaceAll(string);
        try {
            syntaxDocument.replace(0, syntaxDocument.getLength(), string2, null);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(DocumentSearchData.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
    }

    public void doReplace(JTextComponent jTextComponent, String string) {
        if (jTextComponent.getSelectedText() != null) {
            jTextComponent.replaceSelection(string == null ? "" : string);
            this.doFindNext(jTextComponent);
        }
    }

    public boolean doFindPrev(JTextComponent jTextComponent) {
        if (this.getPattern() == null) {
            return false;
        }
        SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(jTextComponent);
        if (syntaxDocument == null) {
            return false;
        }
        int n = jTextComponent.getSelectionStart();
        Matcher matcher = syntaxDocument.getMatcher(this.getPattern());
        if (matcher == null) {
            return false;
        }
        int n2 = -1;
        int n3 = -1;
        while (matcher.find() && matcher.end() < n) {
            n2 = matcher.start();
            n3 = matcher.end();
        }
        if (n3 > 0) {
            jTextComponent.select(n2, n3);
            return true;
        }
        return false;
    }

    public boolean doFindNext(JTextComponent jTextComponent) {
        Matcher matcher;
        if (this.getPattern() == null) {
            return false;
        }
        SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(jTextComponent);
        if (syntaxDocument == null) {
            return false;
        }
        int n = jTextComponent.getSelectionEnd();
        if (jTextComponent.getSelectionEnd() == jTextComponent.getSelectionStart()) {
            ++n;
        }
        if (n >= syntaxDocument.getLength()) {
            n = syntaxDocument.getLength();
        }
        if ((matcher = syntaxDocument.getMatcher(this.getPattern(), n)) != null && matcher.find()) {
            jTextComponent.select(matcher.start() + n, matcher.end() + n);
            return true;
        }
        if (this.isWrap()) {
            matcher = syntaxDocument.getMatcher(this.getPattern());
            if (matcher != null && matcher.find()) {
                jTextComponent.select(matcher.start(), matcher.end());
                return true;
            }
            return false;
        }
        return false;
    }

    public void msgNotFound(Component component) {
        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(component), MessageFormat.format(ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("DocumentSearchData.SearchStringNotFound"), this.getPattern()), ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("DocumentSearchData.Find"), 1);
    }

    public void showReplaceDialog(JTextComponent jTextComponent) {
        if (this.replaceDlg == null) {
            this.replaceDlg = new ReplaceDialog(jTextComponent, this);
        }
        this.replaceDlg.setVisible(true);
    }

    public void showQuickFindDialog(JTextComponent jTextComponent) {
        if (this.quickFindDlg == null) {
            this.quickFindDlg = new QuickFindDialog(jTextComponent, this);
        }
        this.quickFindDlg.showFor(jTextComponent);
    }
}

