/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class IndentAction
extends DefaultSyntaxAction {
    private Pattern wordsPattern = Pattern.compile("\\w+");

    public IndentAction() {
        super("insert-tab");
    }

    @Override
    public void actionPerformed(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n, ActionEvent actionEvent) {
        String string = jTextComponent.getSelectedText();
        EditorKit editorKit = ((JEditorPane)jTextComponent).getEditorKit();
        Map<String, String> map = ((DefaultSyntaxKit)editorKit).getAbbreviations();
        if (string == null) {
            Token token = syntaxDocument.getWordAt(n, this.wordsPattern);
            Integer n2 = ActionUtils.getTabSize(jTextComponent);
            int n3 = syntaxDocument.getParagraphElement(n).getStartOffset();
            int n4 = n - n3;
            int n5 = n2 - n4 % n2;
            if (map == null || token == null) {
                jTextComponent.replaceSelection("                ".substring(0, n5));
            } else {
                String string2 = token.getString(syntaxDocument);
                if (map.containsKey(string2)) {
                    jTextComponent.select(token.start, token.end());
                    string2 = map.get(string2);
                    String[] stringArray = string2.split("\n");
                    if (stringArray.length > 1) {
                        ActionUtils.insertLinesTemplate(jTextComponent, stringArray);
                    } else {
                        ActionUtils.insertSimpleTemplate(jTextComponent, string2);
                    }
                } else {
                    jTextComponent.replaceSelection("                ".substring(0, n5));
                }
            }
        } else {
            String[] stringArray = ActionUtils.getSelectedLines(jTextComponent);
            int n6 = jTextComponent.getSelectionStart();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray) {
                stringBuilder.append(ActionUtils.getTab(jTextComponent));
                stringBuilder.append(string3);
                stringBuilder.append('\n');
            }
            jTextComponent.replaceSelection(stringBuilder.toString());
            jTextComponent.select(n6, n6 + stringBuilder.length());
        }
    }

    public void setWordRegex(String string) {
        this.wordsPattern = Pattern.compile(string);
    }

    public Pattern getWordRegex() {
        return this.wordsPattern;
    }
}

