/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;

public class JIndentAction
extends DefaultSyntaxAction {
    public JIndentAction() {
        super("JINDENT");
    }

    @Override
    public void actionPerformed(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n, ActionEvent actionEvent) {
        int n2 = jTextComponent.getCaretPosition();
        int n3 = syntaxDocument.getParagraphElement(n2).getStartOffset();
        String string = ActionUtils.getLine(jTextComponent);
        String string2 = string.substring(0, n2 - n3);
        String string3 = ActionUtils.getIndent(string);
        Token token = syntaxDocument.getTokenAt(n2);
        if (TokenType.isComment(token)) {
            String string4 = string.trim();
            if (!string4.startsWith("/*") || !string4.endsWith("*/")) {
                if (string4.endsWith("*/")) {
                    try {
                        String string5 = syntaxDocument.getLineAt(token.start);
                        string3 = ActionUtils.getIndent(string5);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.getLogger(JIndentAction.class.getName()).log(Level.SEVERE, null, badLocationException);
                    }
                } else if (string4.startsWith("*")) {
                    string3 = string3 + "* ";
                } else if (string4.startsWith("/**")) {
                    string3 = string3 + " * ";
                } else if (string4.startsWith("/*")) {
                    string3 = string3 + " ";
                }
            }
        } else if (string2.trim().endsWith("{")) {
            string3 = string3 + ActionUtils.getTab(jTextComponent);
        } else {
            String string6 = syntaxDocument.getUncommentedText(n3, n2);
            if (string6.trim().endsWith("{")) {
                string3 = string3 + ActionUtils.getTab(jTextComponent);
            }
        }
        jTextComponent.replaceSelection("\n" + string3);
    }
}

