/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;
import jsyntaxpane.util.Configuration;
import jsyntaxpane.util.JarServiceProvider;

public class ScriptAction
extends DefaultSyntaxAction {
    static final String SCRIPT_FUNCTION = "SCRIPT_FUNCTION";
    static final ScriptEngine engine = new ScriptEngineManager().getEngineByExtension("js");
    static final Invocable invocable = (Invocable)((Object)engine);

    public ScriptAction() {
        super("scripted-action");
    }

    @Override
    public void actionPerformed(JTextComponent jTextComponent, SyntaxDocument syntaxDocument, int n, ActionEvent actionEvent) {
        if (this.getValue(SCRIPT_FUNCTION) != null) {
            String string = this.getValue(SCRIPT_FUNCTION).toString();
            try {
                engine.put("TARGET", jTextComponent);
                engine.put("SDOC", syntaxDocument);
                engine.put("DOT", n);
                engine.put("EVENT", actionEvent);
                engine.put("ACTION", this);
                engine.put("AU", ActionUtils.getInstance());
                invocable.invokeFunction(string, new Object[0]);
            }
            catch (ScriptException scriptException) {
                this.showScriptError(jTextComponent, scriptException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.showScriptError(jTextComponent, noSuchMethodException);
            }
        } else {
            JOptionPane.showMessageDialog(jTextComponent, ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.NoScriptConfigured"), ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.ErrorInScript"), 2);
        }
    }

    public void setFunction(String string) {
        this.putValue(SCRIPT_FUNCTION, string);
    }

    @Override
    public void config(Configuration configuration, String string) {
        super.config(configuration, string);
        for (Configuration.StringKeyMatcher stringKeyMatcher : configuration.getKeys(Pattern.compile("Script\\.((\\w|-)+)\\.URL"))) {
            this.getScriptFromURL(stringKeyMatcher.value);
        }
    }

    public void getScriptFromURL(String string) {
        InputStream inputStream = JarServiceProvider.findResource(string, this.getClass().getClassLoader());
        if (inputStream != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            try {
                engine.eval(inputStreamReader);
            }
            catch (ScriptException scriptException) {
                this.showScriptError(null, scriptException);
            }
        } else {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.NoScriptFoundIn") + string, ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.ErrorInScript"), 2);
        }
    }

    private void showScriptError(JTextComponent jTextComponent, Exception exception) {
        JOptionPane.showMessageDialog(jTextComponent, exception.getMessage(), ResourceBundle.getBundle("jsyntaxpane/Bundle").getString("ScriptAction.ErrorInScript"), 2);
    }
}

