/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DefaultSyntaxAction;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlPrettifyAction
extends DefaultSyntaxAction {
    static Transformer transformer;
    static DocumentBuilderFactory docBuilderFactory;
    static DocumentBuilder docBuilder;

    public XmlPrettifyAction() {
        super("XML_PRETTIFY");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (transformer == null) {
            return;
        }
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        try {
            SyntaxDocument syntaxDocument = ActionUtils.getSyntaxDocument(jTextComponent);
            StringWriter stringWriter = new StringWriter(syntaxDocument.getLength());
            StringReader stringReader = new StringReader(jTextComponent.getText());
            InputSource inputSource = new InputSource(stringReader);
            Document document = this.getDocBuilder().parse(inputSource);
            XmlPrettifyAction.getTransformer().transform(new DOMSource(document), new StreamResult(stringWriter));
            jTextComponent.setText(stringWriter.toString());
        }
        catch (SAXParseException sAXParseException) {
            XmlPrettifyAction.showErrorMessage(jTextComponent, String.format("XML error: %s\nat(%d, %d)", sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()));
            ActionUtils.setCaretPosition(jTextComponent, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber() - 1);
        }
        catch (TransformerException transformerException) {
            XmlPrettifyAction.showErrorMessage(jTextComponent, transformerException.getMessageAndLocation());
        }
        catch (SAXException sAXException) {
            XmlPrettifyAction.showErrorMessage(jTextComponent, sAXException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            XmlPrettifyAction.showErrorMessage(jTextComponent, iOException.getLocalizedMessage());
        }
    }

    private static void showErrorMessage(JTextComponent jTextComponent, String string) {
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        JOptionPane.showMessageDialog(window, string, "JsyntaxPAne XML", 0);
    }

    public static Transformer getTransformer() {
        if (transformer == null) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformer = transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new IllegalArgumentException("Unable to create transformer. ", transformerConfigurationException);
            }
        }
        return transformer;
    }

    public void setIndent(String string) {
        XmlPrettifyAction.getTransformer().setOutputProperty("indent", string);
    }

    public void setStandAlone(String string) {
        XmlPrettifyAction.getTransformer().setOutputProperty("standalone", string);
    }

    public void setSOmitDeclaration(String string) {
        XmlPrettifyAction.getTransformer().setOutputProperty("omit-xml-declaration", string);
    }

    public void setIndentAmount(String string) {
        XmlPrettifyAction.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", string);
    }

    public void setIgnoreComments(String string) {
        XmlPrettifyAction.getDocBuilderFactory().setIgnoringComments(Boolean.parseBoolean(string));
    }

    public void setIgnoreWhiteSpace(String string) {
        XmlPrettifyAction.getDocBuilderFactory().setIgnoringElementContentWhitespace(Boolean.parseBoolean(string));
    }

    public static DocumentBuilderFactory getDocBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return docBuilderFactory;
    }

    public DocumentBuilder getDocBuilder() {
        if (docBuilder == null) {
            try {
                docBuilder = XmlPrettifyAction.getDocBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IllegalArgumentException("Unable to create document builder", parserConfigurationException);
            }
        }
        return docBuilder;
    }
}

