/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.DocumentSearchData;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.components.Markers;
import jsyntaxpane.util.SwingUtils;

public class ReplaceDialog
extends JDialog
implements CaretListener,
EscapeListener {
    private JTextComponent textComponent;
    private DocumentSearchData dsd;
    private static Markers.SimpleMarker SEARCH_MARKER = new Markers.SimpleMarker(Color.YELLOW);
    private JButton jBtnNext;
    private JButton jBtnPrev;
    private JButton jBtnReplace;
    private JButton jBtnReplaceAll;
    private JCheckBox jChkIgnoreCase;
    private JCheckBox jChkRegex;
    private JCheckBox jChkWrap;
    private JComboBox jCmbFind;
    private JComboBox jCmbReplace;
    private JLabel jLblFind;
    private JLabel jLblReplace;
    private JToggleButton jTglHighlight;

    public ReplaceDialog(JTextComponent jTextComponent, DocumentSearchData documentSearchData) {
        super(SwingUtilities.getWindowAncestor(jTextComponent), Dialog.ModalityType.MODELESS);
        this.initComponents();
        this.textComponent = jTextComponent;
        this.dsd = documentSearchData;
        this.textComponent.addCaretListener(this);
        this.setLocationRelativeTo(jTextComponent.getRootPane());
        this.getRootPane().setDefaultButton(this.jBtnNext);
        SwingUtils.addEscapeListener(this);
        this.jBtnReplaceAll.setEnabled(jTextComponent.isEditable() && jTextComponent.isEnabled());
    }

    public void updateHighlights() {
        Markers.removeMarkers(this.textComponent, SEARCH_MARKER);
        if (this.jTglHighlight.isSelected()) {
            Markers.markAll(this.textComponent, this.dsd.getPattern(), SEARCH_MARKER);
        }
    }

    private void showRegexpError(PatternSyntaxException patternSyntaxException) throws HeadlessException {
        JOptionPane.showMessageDialog(this, "Regexp error: " + patternSyntaxException.getMessage(), "Regular Expression Error", 0);
        this.jCmbFind.requestFocus();
    }

    private void updateFinder() {
        String string = (String)this.jCmbFind.getSelectedItem();
        try {
            this.dsd.setPattern(string, this.jChkRegex.isSelected(), this.jChkIgnoreCase.isSelected());
            ActionUtils.insertIntoCombo(this.jCmbFind, string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.showRegexpError(patternSyntaxException);
        }
    }

    private void initComponents() {
        this.jLblFind = new JLabel();
        this.jBtnNext = new JButton();
        this.jBtnPrev = new JButton();
        this.jBtnReplaceAll = new JButton();
        this.jChkWrap = new JCheckBox();
        this.jChkRegex = new JCheckBox();
        this.jChkIgnoreCase = new JCheckBox();
        this.jLblReplace = new JLabel();
        this.jTglHighlight = new JToggleButton();
        this.jCmbReplace = new JComboBox();
        this.jCmbFind = new JComboBox();
        this.jBtnReplace = new JButton();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jsyntaxpane/Bundle");
        this.setTitle(resourceBundle.getString("ReplaceDialog.title"));
        this.setName("");
        this.setResizable(false);
        this.jLblFind.setDisplayedMnemonic('F');
        this.jLblFind.setLabelFor(this.jCmbFind);
        this.jLblFind.setText(resourceBundle.getString("ReplaceDialog.jLblFind.text"));
        this.jBtnNext.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/go-next.png")));
        this.jBtnNext.setMnemonic('N');
        this.jBtnNext.setText(resourceBundle.getString("ReplaceDialog.jBtnNext.text"));
        this.jBtnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceDialog.this.jBtnNextActionPerformed(actionEvent);
            }
        });
        this.jBtnPrev.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/go-previous.png")));
        this.jBtnPrev.setMnemonic('N');
        this.jBtnPrev.setText(resourceBundle.getString("ReplaceDialog.jBtnPrev.text"));
        this.jBtnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceDialog.this.jBtnPrevActionPerformed(actionEvent);
            }
        });
        this.jBtnReplaceAll.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/edit-find-replace-all.png")));
        this.jBtnReplaceAll.setMnemonic('H');
        this.jBtnReplaceAll.setText(resourceBundle.getString("ReplaceDialog.jBtnReplaceAll.text"));
        this.jBtnReplaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceDialog.this.jBtnReplaceAllActionPerformed(actionEvent);
            }
        });
        this.jChkWrap.setMnemonic('W');
        this.jChkWrap.setText(resourceBundle.getString("ReplaceDialog.jChkWrap.text"));
        this.jChkWrap.setToolTipText(resourceBundle.getString("ReplaceDialog.jChkWrap.toolTipText"));
        this.jChkRegex.setMnemonic('R');
        this.jChkRegex.setText(resourceBundle.getString("ReplaceDialog.jChkRegex.text"));
        this.jChkIgnoreCase.setMnemonic('I');
        this.jChkIgnoreCase.setText(resourceBundle.getString("ReplaceDialog.jChkIgnoreCase.text"));
        this.jLblReplace.setDisplayedMnemonic('R');
        this.jLblReplace.setLabelFor(this.jCmbReplace);
        this.jLblReplace.setText(resourceBundle.getString("ReplaceDialog.jLblReplace.text"));
        this.jTglHighlight.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/highlight.png")));
        this.jTglHighlight.setText(resourceBundle.getString("ReplaceDialog.jTglHighlight.text"));
        this.jTglHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceDialog.this.jTglHighlightActionPerformed(actionEvent);
            }
        });
        this.jCmbReplace.setEditable(true);
        this.jCmbFind.setEditable(true);
        this.jBtnReplace.setIcon(new ImageIcon(this.getClass().getResource("/META-INF/images/small-icons/edit-find-replace.png")));
        this.jBtnReplace.setText(resourceBundle.getString("ReplaceDialog.jBtnReplace.text"));
        this.jBtnReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplaceDialog.this.jBtnReplaceActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLblFind).addComponent(this.jLblReplace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCmbFind, 0, 289, Short.MAX_VALUE).addComponent(this.jCmbReplace, GroupLayout.Alignment.TRAILING, 0, 289, Short.MAX_VALUE).addComponent(this.jChkRegex, -1, 289, Short.MAX_VALUE).addComponent(this.jChkWrap, -1, 289, Short.MAX_VALUE).addComponent(this.jChkIgnoreCase, -1, 289, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBtnReplace, GroupLayout.Alignment.TRAILING, -1, 107, Short.MAX_VALUE).addComponent(this.jBtnNext, -1, 107, Short.MAX_VALUE).addComponent(this.jBtnPrev, -1, 107, Short.MAX_VALUE).addComponent(this.jTglHighlight, GroupLayout.Alignment.TRAILING, -1, 107, Short.MAX_VALUE).addComponent(this.jBtnReplaceAll, GroupLayout.Alignment.TRAILING, -1, 107, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblFind).addComponent(this.jCmbFind, -2, -1, -2).addComponent(this.jBtnNext)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnPrev).addComponent(this.jCmbReplace, -2, -1, -2).addComponent(this.jLblReplace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnReplace).addComponent(this.jChkWrap, -2, 23, -2)).addGap(3, 3, 3).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkRegex).addComponent(this.jBtnReplaceAll)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkIgnoreCase).addComponent(this.jTglHighlight)).addContainerGap()));
        this.pack();
    }

    private void jBtnNextActionPerformed(ActionEvent actionEvent) {
        try {
            this.updateFinder();
            if (!this.dsd.doFindNext(this.textComponent)) {
                this.dsd.msgNotFound(this.textComponent);
            }
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.showRegexpError(patternSyntaxException);
        }
    }

    private void jBtnReplaceAllActionPerformed(ActionEvent actionEvent) {
        try {
            this.updateFinder();
            String string = (String)this.jCmbReplace.getSelectedItem();
            if (!this.jChkRegex.isSelected()) {
                string = Matcher.quoteReplacement(string);
            }
            ActionUtils.insertIntoCombo(this.jCmbReplace, string);
            this.jTglHighlight.setSelected(false);
            this.dsd.doReplaceAll(this.textComponent, string);
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.showRegexpError(patternSyntaxException);
        }
    }

    private void jTglHighlightActionPerformed(ActionEvent actionEvent) {
        this.updateFinder();
        this.updateHighlights();
    }

    private void jBtnPrevActionPerformed(ActionEvent actionEvent) {
        this.updateFinder();
        this.dsd.doFindPrev(this.textComponent);
    }

    private void jBtnReplaceActionPerformed(ActionEvent actionEvent) {
        this.jTglHighlight.setSelected(false);
        String string = this.jCmbReplace.getSelectedItem() == null ? "" : this.jCmbReplace.getSelectedItem().toString();
        this.dsd.doReplace(this.textComponent, string);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updateHighlights();
    }

    @Override
    public void escapePressed() {
        this.setVisible(false);
    }
}

