/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxView;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.GotoLineDialog;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;

public class LineNumbersRuler
extends JPanel
implements CaretListener,
DocumentListener,
PropertyChangeListener,
SyntaxComponent {
    public static final String PROPERTY_BACKGROUND = "LineNumbers.Background";
    public static final String PROPERTY_FOREGROUND = "LineNumbers.Foreground";
    public static final String PROPERTY_CURRENT_BACK = "LineNumbers.CurrentBack";
    public static final String PROPERTY_LEFT_MARGIN = "LineNumbers.LeftMargin";
    public static final String PROPERTY_RIGHT_MARGIN = "LineNumbers.RightMargin";
    public static final String PROPERTY_Y_OFFSET = "LineNumbers.YOFFset";
    public static final int DEFAULT_R_MARGIN = 5;
    public static final int DEFAULT_L_MARGIN = 5;
    private SyntaxComponent.Status status;
    private static final int MAX_HEIGHT = 2146483647;
    private JEditorPane editor;
    private int minimumDisplayDigits = 2;
    private int lastDigits;
    private int lastHeight;
    private int lastLine;
    private MouseListener mouseListener = null;
    private String numbersFormat = "%3d";
    private Color currentLineColor;

    public JScrollPane getScrollPane(JTextComponent jTextComponent) {
        for (Container container = jTextComponent.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JScrollPane)) continue;
            return (JScrollPane)container;
        }
        return null;
    }

    @Override
    public void config(Configuration configuration) {
        int n = configuration.getInteger(PROPERTY_RIGHT_MARGIN, 5);
        int n2 = configuration.getInteger(PROPERTY_LEFT_MARGIN, 5);
        Color color = configuration.getColor(PROPERTY_FOREGROUND, Color.BLACK);
        this.setForeground(color);
        Color color2 = configuration.getColor(PROPERTY_BACKGROUND, Color.WHITE);
        this.setBackground(color2);
        this.setBorder(BorderFactory.createEmptyBorder(0, n2, 0, n));
        this.currentLineColor = configuration.getColor(PROPERTY_CURRENT_BACK, color2);
    }

    @Override
    public void install(final JEditorPane jEditorPane) {
        this.editor = jEditorPane;
        this.setFont(jEditorPane.getFont());
        jEditorPane.getDocument().addDocumentListener(this);
        jEditorPane.addCaretListener(this);
        jEditorPane.addPropertyChangeListener(this);
        JScrollPane jScrollPane = this.getScrollPane(jEditorPane);
        jScrollPane.setRowHeaderView(this);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GotoLineDialog.showForEditor(jEditorPane);
            }
        };
        this.addMouseListener(this.mouseListener);
        this.status = SyntaxComponent.Status.INSTALLING;
    }

    @Override
    public void deinstall(JEditorPane jEditorPane) {
        this.removeMouseListener(this.mouseListener);
        this.status = SyntaxComponent.Status.DEINSTALLING;
        this.editor.getDocument().removeDocumentListener(this);
        jEditorPane.removeCaretListener(this);
        jEditorPane.removePropertyChangeListener(this);
        JScrollPane jScrollPane = this.getScrollPane(jEditorPane);
        if (jScrollPane != null) {
            jEditorPane.getDocument().removeDocumentListener(this);
            jScrollPane.setRowHeaderView(null);
        }
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int n) {
        this.minimumDisplayDigits = n;
        this.setPreferredWidth();
    }

    private void setPreferredWidth() {
        int n = ActionUtils.getLineCount(this.editor);
        int n2 = Math.max(String.valueOf(n).length(), this.minimumDisplayDigits);
        if (this.lastDigits != n2) {
            this.lastDigits = n2;
            this.numbersFormat = "%" + n2 + "d";
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = fontMetrics.charWidth('0') * n2;
            Insets insets = this.getInsets();
            int n4 = insets.left + insets.right + n3;
            Dimension dimension = this.getPreferredSize();
            dimension.setSize(n4, 2146483647);
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
        Insets insets = this.getInsets();
        int n = -1;
        try {
            n = ActionUtils.getLineNumber(this.editor, this.editor.getCaretPosition()) + 1;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int n2 = fontMetrics.getHeight();
        int n3 = ActionUtils.getLineCount(this.editor);
        SyntaxView.setRenderingHits((Graphics2D)graphics);
        int n4 = (int)(graphics.getClip().getBounds().getY() / (double)n2) + 1;
        int n5 = (int)graphics.getClip().getBounds().getHeight() + n4;
        for (int i = n4; i <= n5; ++i) {
            String string = String.format(this.numbersFormat, i);
            int n6 = i * n2;
            if (i == n) {
                graphics.setColor(this.currentLineColor);
                graphics.fillRect(0, n6 - n2 + fontMetrics.getDescent() - 1, this.getWidth(), n2);
                graphics.setColor(this.getForeground());
                graphics.drawString(string, insets.left, n6);
                continue;
            }
            graphics.drawString(string, insets.left, n6);
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.editor.getCaretPosition();
        Element element = this.editor.getDocument().getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        if (this.lastLine != n2) {
            this.repaint();
            this.lastLine = n2;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    private void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = ((LineNumbersRuler)LineNumbersRuler.this).editor.getPreferredSize().height;
                if (LineNumbersRuler.this.lastHeight != n) {
                    LineNumbersRuler.this.setPreferredWidth();
                    LineNumbersRuler.this.repaint();
                    LineNumbersRuler.this.lastHeight = n;
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("document")) {
            SyntaxDocument syntaxDocument;
            if (propertyChangeEvent.getOldValue() instanceof SyntaxDocument) {
                syntaxDocument = (SyntaxDocument)propertyChangeEvent.getOldValue();
                syntaxDocument.removeDocumentListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof SyntaxDocument && this.status.equals((Object)SyntaxComponent.Status.INSTALLING)) {
                syntaxDocument = (SyntaxDocument)propertyChangeEvent.getNewValue();
                syntaxDocument.addDocumentListener(this);
                this.setPreferredWidth();
                this.repaint();
            }
        } else if (propertyChangeEvent.getNewValue() instanceof Font) {
            this.setPreferredWidth();
            this.repaint();
        }
    }
}

