/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Experimental
public class DefaultChatRequestParameters
implements ChatRequestParameters {
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer topK;
    private final Double frequencyPenalty;
    private final Double presencePenalty;
    private final Integer maxOutputTokens;
    private final List<String> stopSequences;
    private final List<ToolSpecification> toolSpecifications;
    private final ToolChoice toolChoice;
    private final ResponseFormat responseFormat;

    protected DefaultChatRequestParameters(Builder<?> builder) {
        this.modelName = builder.modelName;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.topK = builder.topK;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.presencePenalty = builder.presencePenalty;
        this.maxOutputTokens = builder.maxOutputTokens;
        this.stopSequences = Utils.copyIfNotNull(builder.stopSequences);
        this.toolSpecifications = Utils.copyIfNotNull(builder.toolSpecifications);
        this.toolChoice = builder.toolChoice;
        this.responseFormat = builder.responseFormat;
    }

    protected DefaultChatRequestParameters(ChatRequestParameters parameters) {
        this.modelName = parameters.modelName();
        this.temperature = parameters.temperature();
        this.topP = parameters.topP();
        this.topK = parameters.topK();
        this.frequencyPenalty = parameters.frequencyPenalty();
        this.presencePenalty = parameters.presencePenalty();
        this.maxOutputTokens = parameters.maxOutputTokens();
        this.stopSequences = Utils.copyIfNotNull(parameters.stopSequences());
        this.toolSpecifications = Utils.copyIfNotNull(parameters.toolSpecifications());
        this.toolChoice = parameters.toolChoice();
        this.responseFormat = parameters.responseFormat();
    }

    @Override
    public String modelName() {
        return this.modelName;
    }

    @Override
    public Double temperature() {
        return this.temperature;
    }

    @Override
    public Double topP() {
        return this.topP;
    }

    @Override
    public Integer topK() {
        return this.topK;
    }

    @Override
    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Override
    public Double presencePenalty() {
        return this.presencePenalty;
    }

    @Override
    public Integer maxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Override
    public List<String> stopSequences() {
        return this.stopSequences;
    }

    @Override
    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    @Override
    public ToolChoice toolChoice() {
        return this.toolChoice;
    }

    @Override
    public ResponseFormat responseFormat() {
        return this.responseFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultChatRequestParameters that = (DefaultChatRequestParameters)o;
        return Objects.equals(this.modelName, that.modelName) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.frequencyPenalty, that.frequencyPenalty) && Objects.equals(this.presencePenalty, that.presencePenalty) && Objects.equals(this.maxOutputTokens, that.maxOutputTokens) && Objects.equals(this.stopSequences, that.stopSequences) && Objects.equals(this.toolSpecifications, that.toolSpecifications) && Objects.equals((Object)this.toolChoice, (Object)that.toolChoice) && Objects.equals(this.responseFormat, that.responseFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modelName, this.temperature, this.topP, this.topK, this.frequencyPenalty, this.presencePenalty, this.maxOutputTokens, this.stopSequences, this.toolSpecifications, this.toolChoice, this.responseFormat});
    }

    public String toString() {
        return "DefaultChatRequestParameters{modelName='" + this.modelName + "', temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", maxOutputTokens=" + this.maxOutputTokens + ", stopSequences=" + String.valueOf(this.stopSequences) + ", toolSpecifications=" + String.valueOf(this.toolSpecifications) + ", toolChoice=" + String.valueOf((Object)this.toolChoice) + ", responseFormat=" + String.valueOf(this.responseFormat) + "}";
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private Double frequencyPenalty;
        private Double presencePenalty;
        private Integer maxOutputTokens;
        private List<String> stopSequences;
        private List<ToolSpecification> toolSpecifications;
        private ToolChoice toolChoice;
        private ResponseFormat responseFormat;

        public T modelName(String modelName) {
            this.modelName = modelName;
            return (T)this;
        }

        public T temperature(Double temperature) {
            this.temperature = temperature;
            return (T)this;
        }

        public T topP(Double topP) {
            this.topP = topP;
            return (T)this;
        }

        public T topK(Integer topK) {
            this.topK = topK;
            return (T)this;
        }

        public T frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return (T)this;
        }

        public T presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return (T)this;
        }

        public T maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return (T)this;
        }

        public T stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return (T)this;
        }

        public T stopSequences(String ... stopSequences) {
            return this.stopSequences(Arrays.asList(stopSequences));
        }

        public T toolSpecifications(List<ToolSpecification> toolSpecifications) {
            this.toolSpecifications = toolSpecifications;
            return (T)this;
        }

        public T toolSpecifications(ToolSpecification ... toolSpecifications) {
            return this.toolSpecifications(Arrays.asList(toolSpecifications));
        }

        public T toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return (T)this;
        }

        public T responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return (T)this;
        }

        public T responseFormat(JsonSchema jsonSchema) {
            if (jsonSchema != null) {
                ResponseFormat responseFormat = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(jsonSchema).build();
                return this.responseFormat(responseFormat);
            }
            return (T)this;
        }

        public DefaultChatRequestParameters build() {
            return new DefaultChatRequestParameters(this);
        }
    }
}

