/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.MMSI;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;
import java.lang.ref.WeakReference;

public class AddressedBinaryMessage
extends AISMessage {
    private transient Integer sequenceNumber;
    private transient MMSI destinationMmsi;
    private transient Boolean retransmit;
    private transient Integer spare;
    private transient Integer designatedAreaCode;
    private transient Integer functionalId;
    private transient WeakReference<String> binaryData;

    public AddressedBinaryMessage(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected AddressedBinaryMessage(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.AddressedBinaryMessage;
    }

    public Integer getSequenceNumber() {
        return this.getDecodedValue(() -> this.sequenceNumber, ref -> {
            this.sequenceNumber = ref;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(38, 40)));
    }

    public MMSI getDestinationMmsi() {
        return this.getDecodedValue(() -> this.destinationMmsi, ref -> {
            this.destinationMmsi = ref;
        }, () -> Boolean.TRUE, () -> MMSI.valueOf(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(40, 70))));
    }

    public Boolean getRetransmit() {
        return this.getDecodedValue(() -> this.retransmit, ref -> {
            this.retransmit = ref;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(70, 71)));
    }

    public int getSpare() {
        return this.getDecodedValue(() -> this.spare, ref -> {
            this.spare = ref;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(71, 72)));
    }

    public Integer getDesignatedAreaCode() {
        return this.getDecodedValue(() -> this.designatedAreaCode, ref -> {
            this.designatedAreaCode = ref;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(72, 82)));
    }

    public Integer getFunctionalId() {
        return this.getDecodedValue(() -> this.functionalId, ref -> {
            this.functionalId = ref;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(82, 88)));
    }

    public String getBinaryData() {
        return this.getDecodedValueByWeakReference(() -> this.binaryData, ref -> {
            this.binaryData = ref;
        }, () -> Boolean.TRUE, () -> Decoders.BIT_DECODER.apply(this.getBits(88, this.getNumberOfBits())));
    }

    @Override
    public String toString() {
        return "AddressedBinaryMessage{messageType=" + (Object)((Object)this.getMessageType()) + ", sequenceNumber=" + this.getSequenceNumber() + ", destinationMmsi=" + this.getDestinationMmsi() + ", retransmit=" + this.getRetransmit() + ", spare=" + this.getSpare() + ", designatedAreaCode=" + this.getDesignatedAreaCode() + ", functionalId=" + this.getFunctionalId() + ", binaryData='" + this.getBinaryData() + '\'' + "} " + super.toString();
    }
}

