/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.PositionFixingDevice;
import dk.tbsalling.aismessages.ais.messages.types.SOTDMACommunicationState;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;
import java.lang.ref.WeakReference;

public class BaseStationReport
extends AISMessage {
    private transient Integer year;
    private transient Integer month;
    private transient Integer day;
    private transient Integer hour;
    private transient Integer minute;
    private transient Integer second;
    private transient Boolean positionAccurate;
    private transient Float latitude;
    private transient Float longitude;
    private transient PositionFixingDevice positionFixingDevice;
    private transient Boolean raimFlag;
    private transient WeakReference<SOTDMACommunicationState> communicationState;

    public BaseStationReport(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected BaseStationReport(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.BaseStationReport;
    }

    public Integer getYear() {
        return this.getDecodedValue(() -> this.year, value -> {
            this.year = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(38, 52)));
    }

    public Integer getMonth() {
        return this.getDecodedValue(() -> this.month, value -> {
            this.month = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(52, 56)));
    }

    public Integer getDay() {
        return this.getDecodedValue(() -> this.day, value -> {
            this.day = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(56, 61)));
    }

    public Integer getHour() {
        return this.getDecodedValue(() -> this.hour, value -> {
            this.hour = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(61, 66)));
    }

    public Integer getMinute() {
        return this.getDecodedValue(() -> this.minute, value -> {
            this.minute = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(66, 72)));
    }

    public Integer getSecond() {
        return this.getDecodedValue(() -> this.second, value -> {
            this.second = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(72, 78)));
    }

    public Boolean getPositionAccurate() {
        return this.getDecodedValue(() -> this.positionAccurate, value -> {
            this.positionAccurate = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(78, 79)));
    }

    public Float getLatitude() {
        return this.getDecodedValue(() -> this.latitude, value -> {
            this.latitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(107, 134)).floatValue() / 600000.0f));
    }

    public Float getLongitude() {
        return this.getDecodedValue(() -> this.longitude, value -> {
            this.longitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(79, 107)).floatValue() / 600000.0f));
    }

    public PositionFixingDevice getPositionFixingDevice() {
        return this.getDecodedValue(() -> this.positionFixingDevice, value -> {
            this.positionFixingDevice = value;
        }, () -> Boolean.TRUE, () -> PositionFixingDevice.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(134, 138))));
    }

    public Boolean getRaimFlag() {
        return this.getDecodedValue(() -> this.raimFlag, value -> {
            this.raimFlag = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(148, 149)));
    }

    public SOTDMACommunicationState getCommunicationState() {
        return this.getDecodedValueByWeakReference(() -> this.communicationState, value -> {
            this.communicationState = value;
        }, () -> Boolean.TRUE, () -> SOTDMACommunicationState.fromBitString(this.getBits(149, 168)));
    }

    @Override
    public String toString() {
        return "BaseStationReport{messageType=" + (Object)((Object)this.getMessageType()) + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ", second=" + this.getSecond() + ", positionAccurate=" + this.getPositionAccurate() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", positionFixingDevice=" + (Object)((Object)this.getPositionFixingDevice()) + ", raimFlag=" + this.getRaimFlag() + ", communicationState=" + this.getCommunicationState() + "} " + super.toString();
    }
}

