/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.StaticDataReport;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.MMSI;
import dk.tbsalling.aismessages.ais.messages.types.ShipType;
import dk.tbsalling.aismessages.ais.messages.types.TransponderClass;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class ClassBCSStaticDataReport
extends AISMessage
implements StaticDataReport {
    private transient Integer partNumber;
    private transient String shipName;
    private transient ShipType shipType;
    private transient String vendorId;
    private transient String callsign;
    private transient Integer toBow;
    private transient Integer toStern;
    private transient Integer toStarboard;
    private transient Integer toPort;
    private transient MMSI mothershipMmsi;

    public ClassBCSStaticDataReport(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected ClassBCSStaticDataReport(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public final AISMessageType getMessageType() {
        return AISMessageType.ClassBCSStaticDataReport;
    }

    @Override
    public TransponderClass getTransponderClass() {
        return TransponderClass.B;
    }

    public Integer getPartNumber() {
        return this.getDecodedValue(() -> this.partNumber, value -> {
            this.partNumber = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(38, 40)));
    }

    @Override
    public String getShipName() {
        return this.getDecodedValue(() -> this.shipName, value -> {
            this.shipName = value;
        }, () -> this.getPartNumber() == 0, () -> Decoders.STRING_DECODER.apply(this.getBits(40, 160)));
    }

    @Override
    public ShipType getShipType() {
        return this.getDecodedValue(() -> this.shipType, value -> {
            this.shipType = value;
        }, () -> this.getPartNumber() == 1, () -> ShipType.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(40, 48))));
    }

    public String getVendorId() {
        return this.getDecodedValue(() -> this.vendorId, value -> {
            this.vendorId = value;
        }, () -> this.getPartNumber() == 1, () -> Decoders.STRING_DECODER.apply(this.getBits(48, 90)));
    }

    @Override
    public String getCallsign() {
        return this.getDecodedValue(() -> this.callsign, value -> {
            this.callsign = value;
        }, () -> this.getPartNumber() == 1, () -> Decoders.STRING_DECODER.apply(this.getBits(90, 132)));
    }

    @Override
    public Integer getToBow() {
        return this.getDecodedValue(() -> this.toBow, value -> {
            this.toBow = value;
        }, () -> this.getPartNumber() == 1, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(132, 141)));
    }

    @Override
    public Integer getToStern() {
        return this.getDecodedValue(() -> this.toStern, value -> {
            this.toStern = value;
        }, () -> this.getPartNumber() == 1, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(141, 150)));
    }

    @Override
    public Integer getToStarboard() {
        return this.getDecodedValue(() -> this.toStarboard, value -> {
            this.toStarboard = value;
        }, () -> this.getPartNumber() == 1, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(156, 162)));
    }

    @Override
    public Integer getToPort() {
        return this.getDecodedValue(() -> this.toPort, value -> {
            this.toPort = value;
        }, () -> this.getPartNumber() == 1, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(150, 156)));
    }

    public MMSI getMothershipMmsi() {
        return this.getDecodedValue(() -> this.mothershipMmsi, value -> {
            this.mothershipMmsi = value;
        }, () -> this.getPartNumber() == 1, () -> MMSI.valueOf(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(132, 162))));
    }

    @Override
    public String toString() {
        return "ClassBCSStaticDataReport{messageType=" + (Object)((Object)this.getMessageType()) + ", partNumber=" + this.getPartNumber() + ", shipName='" + this.getShipName() + '\'' + ", shipType=" + (Object)((Object)this.getShipType()) + ", vendorId='" + this.getVendorId() + '\'' + ", callsign='" + this.getCallsign() + '\'' + ", toBow=" + this.getToBow() + ", toStern=" + this.getToStern() + ", toStarboard=" + this.getToStarboard() + ", toPort=" + this.getToPort() + ", mothershipMmsi=" + this.getMothershipMmsi() + "} " + super.toString();
    }
}

