/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.ais.messages;

import dk.tbsalling.aismessages.ais.Decoders;
import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.DynamicDataReport;
import dk.tbsalling.aismessages.ais.messages.types.AISMessageType;
import dk.tbsalling.aismessages.ais.messages.types.NavigationStatus;
import dk.tbsalling.aismessages.ais.messages.types.TransponderClass;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;

public class LongRangeBroadcastMessage
extends AISMessage
implements DynamicDataReport {
    private transient Boolean positionAccuracy;
    private transient Boolean raim;
    private transient NavigationStatus navigationStatus;
    private transient Float longitude;
    private transient Float latitude;
    private transient Integer speed;
    private transient Integer course;
    private transient Integer positionLatency;
    private transient Integer spare;

    public LongRangeBroadcastMessage(NMEAMessage[] nmeaMessages) {
        super(nmeaMessages);
    }

    protected LongRangeBroadcastMessage(NMEAMessage[] nmeaMessages, String bitString) {
        super(nmeaMessages, bitString);
    }

    @Override
    protected void checkAISMessage() {
    }

    @Override
    public AISMessageType getMessageType() {
        return AISMessageType.LongRangeBroadcastMessage;
    }

    @Override
    public TransponderClass getTransponderClass() {
        return TransponderClass.A;
    }

    public Boolean getPositionAccuracy() {
        return this.getDecodedValue(() -> this.positionAccuracy, value -> {
            this.positionAccuracy = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(38, 39)));
    }

    public Boolean getRaim() {
        return this.getDecodedValue(() -> this.raim, value -> {
            this.raim = value;
        }, () -> Boolean.TRUE, () -> Decoders.BOOLEAN_DECODER.apply(this.getBits(39, 40)));
    }

    public NavigationStatus getNavigationalStatus() {
        return this.getDecodedValue(() -> this.navigationStatus, value -> {
            this.navigationStatus = value;
        }, () -> Boolean.TRUE, () -> NavigationStatus.fromInteger(Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(40, 44))));
    }

    @Override
    public Float getLongitude() {
        return this.getDecodedValue(() -> this.longitude, value -> {
            this.longitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(44, 62)).floatValue() / 600.0f));
    }

    @Override
    public Float getLatitude() {
        return this.getDecodedValue(() -> this.latitude, value -> {
            this.latitude = value;
        }, () -> Boolean.TRUE, () -> Float.valueOf(Decoders.FLOAT_DECODER.apply(this.getBits(62, 79)).floatValue() / 600.0f));
    }

    @Override
    public Float getSpeedOverGround() {
        return Float.valueOf(this.getDecodedValue(() -> this.speed, value -> {
            this.speed = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(79, 85))).intValue());
    }

    @Override
    public Float getCourseOverGround() {
        return Float.valueOf(this.getDecodedValue(() -> this.course, value -> {
            this.course = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(85, 94))).intValue());
    }

    public Integer getPositionLatency() {
        return this.getDecodedValue(() -> this.positionLatency, value -> {
            this.positionLatency = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(94, 95)));
    }

    public Integer getSpare() {
        return this.getDecodedValue(() -> this.spare, value -> {
            this.spare = value;
        }, () -> Boolean.TRUE, () -> Decoders.UNSIGNED_INTEGER_DECODER.apply(this.getBits(95, 96)));
    }

    @Override
    public String toString() {
        return "LongRangeBroadcastMessage{messageType=" + (Object)((Object)this.getMessageType()) + ", positionAccuracy=" + this.getPositionAccuracy() + ", raim=" + this.getRaim() + ", status=" + (Object)((Object)this.getNavigationalStatus()) + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", speed=" + this.getSpeedOverGround() + ", course=" + this.getCourseOverGround() + ", positionLatency=" + this.getPositionLatency() + ", spare=" + this.getSpare() + "} " + super.toString();
    }
}

