/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.nmea;

import dk.tbsalling.aismessages.ais.messages.AISMessage;
import dk.tbsalling.aismessages.ais.messages.Metadata;
import dk.tbsalling.aismessages.nmea.messages.NMEAMessage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class NMEAMessageHandler
implements Consumer<NMEAMessage> {
    private static final Logger LOG = Logger.getLogger(NMEAMessageHandler.class.getName());
    private final String source;
    private final ArrayList<NMEAMessage> messageFragments = new ArrayList();
    private final List<Consumer<? super AISMessage>> aisMessageReceivers = new LinkedList<Consumer<? super AISMessage>>();

    public NMEAMessageHandler(String source, Consumer<? super AISMessage> ... aisMessageReceivers) {
        this.source = source;
        for (Consumer<? super AISMessage> aisMessageReceiver : aisMessageReceivers) {
            this.addAisMessageReceiver(aisMessageReceiver);
        }
    }

    @Override
    public void accept(NMEAMessage nmeaMessage) {
        LOG.finer("Received for processing: " + nmeaMessage.getRawMessage());
        if (!nmeaMessage.isValid()) {
            LOG.warning("NMEA message is invalid: " + nmeaMessage.toString());
            return;
        }
        int numberOfFragments = nmeaMessage.getNumberOfFragments();
        if (numberOfFragments <= 0) {
            LOG.warning("NMEA message is invalid: " + nmeaMessage.toString());
            this.messageFragments.clear();
        } else if (numberOfFragments == 1) {
            LOG.finest("Handling unfragmented NMEA message");
            AISMessage aisMessage = AISMessage.create(new Metadata(this.source), nmeaMessage);
            this.sendToAisMessageReceivers(aisMessage);
            this.messageFragments.clear();
        } else {
            int fragmentNumber = nmeaMessage.getFragmentNumber();
            LOG.finest("Handling fragmented NMEA message with fragment number " + fragmentNumber);
            if (fragmentNumber < 0) {
                LOG.warning("Fragment number cannot be negative: " + fragmentNumber + ": " + nmeaMessage.getRawMessage());
                this.messageFragments.clear();
            } else if (fragmentNumber > numberOfFragments) {
                LOG.fine("Fragment number " + fragmentNumber + " higher than expected " + numberOfFragments + ": " + nmeaMessage.getRawMessage());
                this.messageFragments.clear();
            } else {
                int expectedFragmentNumber = this.messageFragments.size() + 1;
                LOG.finest("Expected fragment number is: " + expectedFragmentNumber + ": " + nmeaMessage.getRawMessage());
                if (expectedFragmentNumber != fragmentNumber) {
                    LOG.fine("Expected fragment number " + expectedFragmentNumber + "; not " + fragmentNumber + ": " + nmeaMessage.getRawMessage());
                    this.messageFragments.clear();
                } else {
                    this.messageFragments.add(nmeaMessage);
                    LOG.finest("nmeaMessage.getNumberOfFragments(): " + nmeaMessage.getNumberOfFragments());
                    LOG.finest("messageFragments.size(): " + this.messageFragments.size());
                    if (nmeaMessage.getNumberOfFragments().intValue() == this.messageFragments.size()) {
                        AISMessage aisMessage = AISMessage.create(new Metadata(this.source), this.messageFragments.toArray(new NMEAMessage[this.messageFragments.size()]));
                        this.sendToAisMessageReceivers(aisMessage);
                        this.messageFragments.clear();
                    } else {
                        LOG.finest("Fragmented message not yet complete; missing " + (nmeaMessage.getNumberOfFragments() - this.messageFragments.size()) + " fragment(s).");
                    }
                }
            }
        }
    }

    private void sendToAisMessageReceivers(AISMessage aisMessage) {
        this.aisMessageReceivers.forEach(r -> r.accept(aisMessage));
    }

    public void addAisMessageReceiver(Consumer<? super AISMessage> aisMessageReceiver) {
        this.aisMessageReceivers.add(aisMessageReceiver);
    }

    public ArrayList<NMEAMessage> flush() {
        ArrayList unhandled = (ArrayList)this.messageFragments.clone();
        this.messageFragments.clear();
        return unhandled;
    }
}

