/*
 * Decompiled with CFR 0.152.
 */
package dk.tbsalling.aismessages.nmea.messages;

import dk.tbsalling.aismessages.nmea.exceptions.NMEAParseException;
import dk.tbsalling.aismessages.nmea.exceptions.UnsupportedMessageType;
import java.io.Serializable;

public class NMEAMessage
implements Serializable {
    private final String rawMessage;

    public static NMEAMessage fromString(String nmeaString) {
        return new NMEAMessage(nmeaString);
    }

    public final boolean isValid() {
        String messageType = this.getMessageType();
        if (messageType == null || messageType.length() != 5) {
            return false;
        }
        String type = messageType.substring(2);
        return "VDM".equals(type) || "VDO".equals(type);
    }

    public String getMessageType() {
        String[] msg = this.rawMessage.split(",");
        return NMEAMessage.isBlank(msg[0]) ? null : msg[0].replace("!", "");
    }

    public Integer getNumberOfFragments() {
        String[] msg = this.rawMessage.split(",");
        return NMEAMessage.isBlank(msg[1]) ? null : Integer.valueOf(msg[1]);
    }

    public Integer getFragmentNumber() {
        String[] msg = this.rawMessage.split(",");
        return NMEAMessage.isBlank(msg[2]) ? null : Integer.valueOf(msg[2]);
    }

    public Integer getSequenceNumber() {
        String[] msg = this.rawMessage.split(",");
        return NMEAMessage.isBlank(msg[3]) ? null : Integer.valueOf(msg[3]);
    }

    public String getRadioChannelCode() {
        String[] msg = this.rawMessage.split(",");
        return NMEAMessage.isBlank(msg[4]) ? null : msg[4];
    }

    public String getEncodedPayload() {
        String[] msg = this.rawMessage.split(",");
        return NMEAMessage.isBlank(msg[5]) ? null : msg[5];
    }

    public Integer getFillBits() {
        String[] msg = this.rawMessage.split(",");
        String[] msg1 = msg[6].split("\\*");
        return NMEAMessage.isBlank(msg1[0]) ? null : Integer.valueOf(msg1[0]);
    }

    public Integer getChecksum() {
        String[] msg = this.rawMessage.split(",");
        String[] msg1 = msg[6].split("\\*");
        return NMEAMessage.isBlank(msg1[1]) ? null : Integer.valueOf(msg1[1], 16);
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    private NMEAMessage(String rawMessage) {
        this.rawMessage = rawMessage;
        this.validate();
    }

    private void validate() {
        if (!this.isValid()) {
            throw new UnsupportedMessageType(this.getMessageType());
        }
        String nmeaMessageRegExp = "^!.*\\*[0-9A-Fa-f]{2}$";
        if (!this.rawMessage.matches("^!.*\\*[0-9A-Fa-f]{2}$")) {
            throw new NMEAParseException(this.rawMessage, "Message does not comply with regexp \"^!.*\\*[0-9A-Fa-f]{2}$\"");
        }
        String[] msg = this.rawMessage.split(",");
        if (msg.length != 7) {
            throw new NMEAParseException(this.rawMessage, "Expected 7 fields separated by commas; got " + msg.length);
        }
        String[] msg1 = msg[6].split("\\*");
        if (msg1.length != 2) {
            throw new NMEAParseException(this.rawMessage, "Expected checksum fields to start with *");
        }
    }

    public String toString() {
        return "NMEAMessage{rawMessage='" + this.rawMessage + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NMEAMessage that = (NMEAMessage)o;
        return this.rawMessage.equals(that.rawMessage);
    }

    public int hashCode() {
        return this.rawMessage.hashCode();
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }
}

