/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.testing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.units.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class TestingHttpClient
implements HttpClient {
    private final Function<Request, Response> processor;
    private final ListeningExecutorService executor;
    private final RequestStats stats = new RequestStats();
    private final AtomicBoolean closed = new AtomicBoolean();

    public TestingHttpClient(Function<Request, Response> processor) {
        this(processor, (ExecutorService)MoreExecutors.newDirectExecutorService());
    }

    public TestingHttpClient(Function<Request, Response> processor, ExecutorService executor) {
        this.processor = processor;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        Preconditions.checkNotNull((Object)request, (Object)"request is null");
        Preconditions.checkNotNull(responseHandler, (Object)"responseHandler is null");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"client is closed");
        AtomicReference<String> state = new AtomicReference<String>("SENDING_REQUEST");
        ListenableFuture future = this.executor.submit(() -> this.execute(request, responseHandler, state));
        return new TestingHttpResponseFuture(future, state);
    }

    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        Preconditions.checkNotNull((Object)request, (Object)"request is null");
        Preconditions.checkNotNull(responseHandler, (Object)"responseHandler is null");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"client is closed");
        return this.execute(request, responseHandler, new AtomicReference<String>("SENDING_REQUEST"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler, AtomicReference<String> state) throws E {
        Duration requestProcessingTime;
        Response response;
        state.set("PROCESSING_REQUEST");
        long requestStart = System.nanoTime();
        try {
            response = (Response)this.processor.apply((Object)request);
            requestProcessingTime = Duration.nanosSince((long)requestStart);
        }
        catch (Throwable e) {
            state.set("FAILED");
            this.stats.record(request.getMethod(), 0, 0L, 0L, Duration.nanosSince((long)requestStart), null);
            if (e instanceof Exception) {
                return responseHandler.handleException(request, (Exception)e);
            }
            throw e;
        }
        Preconditions.checkState((response != null ? 1 : 0) != 0, (Object)"response is null");
        state.set("PROCESSING_RESPONSE");
        long responseStart = System.nanoTime();
        try {
            T t = responseHandler.handle(request, response);
            return t;
        }
        finally {
            state.set("DONE");
            Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
            this.stats.record(request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
        }
    }

    @Override
    public RequestStats getStats() {
        return this.stats;
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    private class TestingHttpResponseFuture<T>
    extends ForwardingListenableFuture<T>
    implements HttpClient.HttpResponseFuture<T> {
        private final AtomicReference<String> state;
        private final ListenableFuture<T> future;

        private TestingHttpResponseFuture(ListenableFuture<T> future, AtomicReference<String> state) {
            this.future = future;
            this.state = state;
        }

        protected ListenableFuture<T> delegate() {
            return this.future;
        }

        @Override
        public String getState() {
            return this.state.get();
        }
    }
}

