/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core.utilities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.apimatic.core.annotations.TypeCombinator;
import io.apimatic.core.types.http.request.MultipartFileWrapper;
import io.apimatic.core.types.http.request.MultipartWrapper;
import io.apimatic.core.utilities.CoreJsonObject;
import io.apimatic.core.utilities.CoreJsonValue;
import io.apimatic.coreinterfaces.http.request.ArraySerializationFormat;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class CoreHelper {
    private static String userAgent;
    private static final String TSV_FORMAT = "%09";
    private static final String CSV_FORMAT = ",";
    private static final String PSV_FORMAT = "%7C";
    private static ObjectMapper mapper;
    private static ObjectMapper strictMapper;
    private static final Set<Object> WRAPPER_TYPES;

    protected CoreHelper() {
    }

    private static JsonSerializer<?> getCollectionCustomSerializer(TypeCombinator.FormSerialize serializerAnnotation) {
        try {
            return serializerAnnotation.contentUsing().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static JsonSerializer<?> getSerializer(JsonSerialize serializerAnnotation) {
        try {
            return (JsonSerializer)serializerAnnotation.using().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static JsonSerializer<?> getCollectionSerializer(JsonSerialize serializerAnnotation) {
        try {
            return (JsonSerializer)serializerAnnotation.contentUsing().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static ObjectMapper getStrictMapper() {
        return strictMapper;
    }

    public static String serialize(Object obj) throws JsonProcessingException {
        if (obj == null) {
            return null;
        }
        return mapper.writeValueAsString(obj);
    }

    public static String serialize(Object obj, JsonSerializer serializer) throws JsonProcessingException {
        if (obj == null || serializer == null) {
            return null;
        }
        Class<?> cls = null;
        cls = obj.getClass().getName().equals("java.util.ArrayList") ? ((ArrayList)obj).get(0).getClass() : (obj.getClass().getName().equals("java.util.LinkedHashMap") ? ((LinkedHashMap)obj).values().toArray()[0].getClass() : obj.getClass());
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(cls, serializer);
        objectMapper.registerModule((Module)module);
        return objectMapper.writeValueAsString(obj);
    }

    public static <T> String serializeXmlArray(T[] objArray, String rootName, String nodeName, Class<T> cls) throws IOException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{cls});
            String xmlBlock = "<" + rootName + ">\n";
            for (T element : objArray) {
                JAXBElement jaxbElement = new JAXBElement(new QName(nodeName), cls, element);
                StringWriter writer = new StringWriter();
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.fragment", (Object)true);
                marshaller.marshal((Object)jaxbElement, (Writer)writer);
                xmlBlock = xmlBlock + "  " + writer.toString() + "\n";
            }
            xmlBlock = xmlBlock + "</" + rootName + ">";
            return xmlBlock;
        }
        catch (JAXBException jaxbException) {
            throw new IOException(jaxbException);
        }
    }

    public static <T> String serializeXml(T obj, String rootName, Class<T> cls) throws IOException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            JAXBElement elem = new JAXBElement(new QName(rootName), cls, obj);
            StringWriter writer = new StringWriter();
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)elem, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException jaxbException) {
            throw new IOException(jaxbException);
        }
    }

    public static String serializeTypeCombinator(Object obj) throws JsonProcessingException {
        if (obj == null) {
            return null;
        }
        TypeCombinator.TypeCombinatorStringCase stringCaseAnnotation = obj.getClass().getAnnotation(TypeCombinator.TypeCombinatorStringCase.class);
        if (stringCaseAnnotation != null) {
            return obj.toString();
        }
        return CoreHelper.serialize(obj);
    }

    public static <T1, T2> T1 deserialize(JsonNode jsonNode, TypeReference<T1> typeReference, Class<T2> cls, JsonDeserializer<T2> deserializer) throws IOException {
        if (jsonNode == null) {
            return null;
        }
        return CoreHelper.deserialize(mapper.writeValueAsString((Object)jsonNode), typeReference, cls, deserializer);
    }

    public static <T1, T2> T1 deserialize(String json, TypeReference<T1> typeReference, final Class<T2> cls, final JsonDeserializer<T2> deserializer) throws IOException {
        if (CoreHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T1)new ObjectMapper(){
            private static final long serialVersionUID = -1639089569991988232L;
            {
                SimpleModule module = new SimpleModule();
                module.addDeserializer(cls, deserializer);
                this.registerModule((Module)module);
            }
        }.readValue(json, typeReference);
    }

    public static <T> T deserialize(String json, Class<T> clazz) throws IOException {
        if (CoreHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T)mapper.readValue(json, clazz);
    }

    public static <T> T deserialize(JsonNode json, List<Class<? extends T>> classes, boolean isOneOf) throws IOException {
        if (json == null) {
            return null;
        }
        Object deserializedObject = null;
        int deserializationCount = 0;
        for (Class<T> clazz : classes) {
            try {
                if (isOneOf) {
                    deserializedObject = strictMapper.convertValue((Object)json, clazz);
                    if (++deserializationCount <= 1) continue;
                    throw new IOException("More than 1 matching one-of types found against given json");
                }
                return (T)strictMapper.convertValue((Object)json, clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (deserializationCount == 0) {
            throw new IOException("No " + (isOneOf ? "one-of" : "any-of") + " type deserializer found against given json");
        }
        return (T)deserializedObject;
    }

    public static LinkedHashMap<String, Object> deserialize(String json) throws IOException {
        if (CoreHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
        return CoreHelper.deserialize(json, typeRef);
    }

    public static <T> T deserialize(String json, TypeReference<T> typeReference) throws IOException {
        if (CoreHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return (T)mapper.readValue(json, typeReference);
    }

    public static <T> T deserialize(JsonNode jsonNode, TypeReference<T> typeReference) throws IOException {
        if (jsonNode == null) {
            return null;
        }
        return (T)strictMapper.convertValue((Object)jsonNode, typeReference);
    }

    public static <T> T deserialize(JsonNode jsonNode, Class<T> clazz) throws IOException {
        if (jsonNode == null) {
            return null;
        }
        return (T)strictMapper.convertValue((Object)jsonNode, clazz);
    }

    public static <T> T deserializeXml(String xml, Class<T> cls) throws IOException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{cls});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            JAXBElement jaxbElement = jaxbUnmarshaller.unmarshal((Source)new StreamSource(reader), cls);
            return (T)jaxbElement.getValue();
        }
        catch (JAXBException jaxbException) {
            throw new IOException(jaxbException);
        }
    }

    public static <T> List<T> deserializeXmlArray(String xml, Class<T[]> cls) throws IOException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{cls});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringReader reader = new StringReader(xml);
            JAXBElement jaxbElement = jaxbUnmarshaller.unmarshal((Source)new StreamSource(reader), cls);
            return Arrays.asList((Object[])jaxbElement.getValue());
        }
        catch (JAXBException jaxbException) {
            throw new IOException(jaxbException);
        }
    }

    public static <T> List<T> deserializeXmlSimpleTypesArray(String xml, Class<T> cls) throws IOException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{cls});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            ArrayList<Object> deserializedList = new ArrayList<Object>();
            Pattern pattern = Pattern.compile("<.+?>(.+?)</.+?>");
            Matcher patternMatcher = pattern.matcher(xml);
            while (patternMatcher.find()) {
                StringReader reader = new StringReader(patternMatcher.group());
                Object unmarshalledElement = jaxbUnmarshaller.unmarshal((Source)new StreamSource(reader), cls).getValue();
                deserializedList.add(unmarshalledElement);
            }
            return deserializedList;
        }
        catch (JAXBException jaxbException) {
            throw new IOException(jaxbException);
        }
    }

    public static <T> T deserialize(JsonParser jp, DeserializationContext ctxt, String discriminator, List<Map<String, Class<? extends T>>> registry, List<Class<? extends T>> typesWithoutDiscriminator, boolean isOneOf) throws IOException {
        ObjectCodec oc = jp.getCodec();
        JsonNode jsonNode = (JsonNode)oc.readTree(jp);
        List<Class<T>> types = CoreHelper.deduceType(jsonNode, discriminator, registry);
        if (types == null || types.isEmpty()) {
            if (typesWithoutDiscriminator != null && !typesWithoutDiscriminator.isEmpty()) {
                types = typesWithoutDiscriminator;
            } else {
                throw new IOException("Discriminator is missing.");
            }
        }
        return CoreHelper.deserialize(jsonNode, types, isOneOf);
    }

    public static Object deserializeAsObject(String json) {
        if (CoreHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        try {
            return CoreHelper.deserialize(json, new TypeReference<Object>(){});
        }
        catch (IOException e) {
            return json;
        }
    }

    public static <T> List<T> deserializeArray(String json, Class<T[]> classArray) throws IOException {
        if (CoreHelper.isNullOrWhiteSpace(json)) {
            return null;
        }
        return Arrays.asList((Object[])mapper.readValue(json, classArray));
    }

    public static void appendUrlWithTemplateParameters(StringBuilder queryBuilder, Map<String, AbstractMap.SimpleEntry<Object, Boolean>> parameters) {
        if (null == queryBuilder) {
            throw new IllegalArgumentException("Given value for parameter \"queryBuilder\" is invalid.");
        }
        if (null == parameters) {
            return;
        }
        for (Map.Entry<String, AbstractMap.SimpleEntry<Object, Boolean>> pair : parameters.entrySet()) {
            String replaceValue = "";
            Object element = pair.getValue().getKey();
            boolean shouldEncode = pair.getValue().getValue();
            replaceValue = null == element ? "" : (element instanceof Collection ? CoreHelper.flattenCollection("", (Collection)element, shouldEncode, "%s%s%s", '/') : (shouldEncode ? CoreHelper.tryUrlEncode(element.toString(), false) : element.toString()));
            CoreHelper.replaceAll(queryBuilder, "{" + pair.getKey() + "}", replaceValue);
        }
    }

    public static void appendUrlWithQueryParameters(StringBuilder queryBuilder, Map<String, Object> parameters, ArraySerializationFormat arraySerializationFormat) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("Given value for parameter \"queryBuilder\" is invalid.");
        }
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        boolean hasParams = queryBuilder.indexOf("?") > 0;
        queryBuilder.append(hasParams ? (char)'&' : '?');
        CoreHelper.encodeObjectAsQueryString("", parameters, queryBuilder, arraySerializationFormat);
    }

    public static boolean isNullOrWhiteSpace(String s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        if (length > 0) {
            int start = 0;
            int middle = length / 2;
            int end = length - 1;
            while (start <= middle) {
                if (s.charAt(start) > ' ' || s.charAt(end) > ' ') {
                    return false;
                }
                ++start;
                --end;
            }
            return true;
        }
        return false;
    }

    public static void replaceAll(StringBuilder stringBuilder, String toReplace, String replaceWith) {
        int index = stringBuilder.indexOf(toReplace);
        while (index != -1) {
            stringBuilder.replace(index, index + toReplace.length(), replaceWith);
            index += replaceWith.length();
            index = stringBuilder.indexOf(toReplace, index);
        }
    }

    public static String updateUserAgent(String apiUserAgent, Map<String, String> userAgentConfig) {
        String engineVersion = System.getProperty("java.runtime.version");
        String osName = System.getProperty("os.name") + "-" + System.getProperty("os.version");
        userAgent = apiUserAgent;
        userAgent = userAgent.replace("{engine}", "JRE");
        userAgent = userAgent.replace("{engine-version}", engineVersion != null ? engineVersion : "");
        userAgent = userAgent.replace("{os-info}", osName != null ? osName : "");
        if (userAgentConfig != null) {
            userAgentConfig.forEach((key, value) -> {
                userAgent = userAgent.replace((CharSequence)key, (CharSequence)value);
            });
        }
        return userAgent;
    }

    public static void removeNullValues(Map<String, ?> map) {
        if (map == null) {
            return;
        }
        map.values().removeAll(Collections.singleton(null));
    }

    public static String cleanUrl(StringBuilder url) {
        Pattern pattern = Pattern.compile("^(https?://[^/]+)");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid Url format.");
        }
        String protocol = matcher.group(1);
        String query = url.substring(protocol.length());
        query = query.replaceAll("//+", "/");
        return protocol.concat(query);
    }

    public static List<AbstractMap.SimpleEntry<String, Object>> prepareFormFields(Map<?, ?> value, ArraySerializationFormat arraySerializationFormat) {
        ArrayList<AbstractMap.SimpleEntry<String, Object>> formFields = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
        if (value != null) {
            CoreHelper.objectToList("", value, formFields, new HashSet<Integer>(), arraySerializationFormat);
        }
        return formFields;
    }

    public static <T> List<T> deserializeArray(JsonNode json, Class<T[]> classArray) throws IOException {
        if (json == null) {
            return null;
        }
        return Arrays.asList((Object[])strictMapper.convertValue((Object)json, classArray));
    }

    private static <T> List<Class<? extends T>> deduceType(JsonNode jsonNode, String discriminator, List<Map<String, Class<? extends T>>> registry) throws IOException {
        if (jsonNode == null || registry == null) {
            return null;
        }
        String discriminatorValue = jsonNode.isArray() ? (jsonNode.has(0) && jsonNode.get(0).has(discriminator) ? jsonNode.get(0).get(discriminator).asText() : CoreHelper.deduceTypeFromImmidiateChild(jsonNode.get(0), discriminator)) : (jsonNode.has(discriminator) ? jsonNode.get(discriminator).asText() : CoreHelper.deduceTypeFromImmidiateChild(jsonNode, discriminator));
        return registry.stream().filter(item -> item.get(discriminatorValue) != null).map(item -> (Class)item.get(discriminatorValue)).distinct().collect(Collectors.toList());
    }

    private static String deduceTypeFromImmidiateChild(JsonNode jsonNode, String discriminator) {
        for (JsonNode tempNode : jsonNode) {
            if (tempNode.isArray()) {
                if (!tempNode.has(0) || !tempNode.get(0).has(discriminator)) continue;
                return tempNode.get(0).get(discriminator).asText();
            }
            if (!tempNode.has(discriminator)) continue;
            return tempNode.get(discriminator).asText();
        }
        return null;
    }

    private static void encodeObjectAsQueryString(String name, Object obj, StringBuilder objBuilder, ArraySerializationFormat arraySerializationFormat) {
        ArrayList<AbstractMap.SimpleEntry<String, Object>> objectList = new ArrayList<AbstractMap.SimpleEntry<String, Object>>();
        CoreHelper.objectToList(name, obj, objectList, new HashSet<Integer>(), arraySerializationFormat);
        boolean hasParam = false;
        ArrayList<String> arrays = new ArrayList<String>();
        for (AbstractMap.SimpleEntry simpleEntry : objectList) {
            String accessor = (String)simpleEntry.getKey();
            Object value = simpleEntry.getValue();
            if (value == null) continue;
            hasParam = true;
            if (accessor.matches(".*?\\[\\d+\\]$") && CoreHelper.isDelimeterFormat(arraySerializationFormat)) {
                String arrayName = accessor.substring(0, accessor.lastIndexOf(91));
                if (arrays.contains(arrayName)) {
                    objBuilder.setLength(objBuilder.length() - 1);
                    accessor = CoreHelper.getAccessorStringFormat(arraySerializationFormat);
                } else {
                    accessor = arrayName + "=";
                }
                if (!arrays.contains(arrayName)) {
                    arrays.add(arrayName);
                }
                CoreHelper.appendParamKeyValuePair("%s%s&", objBuilder, accessor, value);
                continue;
            }
            CoreHelper.appendParamKeyValuePair("%s=%s&", objBuilder, accessor, value);
        }
        if (hasParam) {
            objBuilder.setLength(objBuilder.length() - 1);
        }
    }

    private static void appendParamKeyValuePair(String formatString, StringBuilder objBuilder, String accessor, Object value) {
        String paramKeyValPair = String.format(formatString, accessor, CoreHelper.tryUrlEncode(value.toString(), false));
        objBuilder.append(paramKeyValPair);
    }

    private static String flattenCollection(String elemName, Collection<?> array, boolean encode, String fmt, char separator) {
        StringBuilder builder = new StringBuilder();
        for (Object element : array) {
            String elemValue = null;
            elemValue = element == null ? "" : element.toString();
            if (encode) {
                elemValue = CoreHelper.tryUrlEncode(elemValue, false);
            }
            builder.append(String.format(fmt, elemName, elemValue, Character.valueOf(separator)));
        }
        if (builder.length() > 1 && builder.charAt(builder.length() - 1) == separator) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String tryUrlEncode(String value, boolean spaceAsPercentEncoded) {
        try {
            String encodedUrl = URLEncoder.encode(value, "UTF-8");
            if (spaceAsPercentEncoded) {
                return encodedUrl.replace("+", "%20");
            }
            return encodedUrl;
        }
        catch (UnsupportedEncodingException ex) {
            return value;
        }
    }

    public static String getBase64EncodedCredentials(String basicAuthUserName, String basicAuthPassword) {
        String authCredentials = basicAuthUserName + ":" + basicAuthPassword;
        return "Basic " + Base64.getEncoder().encodeToString(authCredentials.getBytes());
    }

    private static void objectToList(String objName, Collection<?> obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, ArraySerializationFormat arraySerializationFormat) {
        Collection<?> array = obj;
        int index = 0;
        for (Object element : array) {
            String key = CoreHelper.isWrapperType(element) && (arraySerializationFormat == ArraySerializationFormat.UNINDEXED || arraySerializationFormat == ArraySerializationFormat.PLAIN) ? (arraySerializationFormat == ArraySerializationFormat.UNINDEXED ? String.format("%s[]", objName) : objName) : String.format("%s[%d]", objName, index++);
            CoreHelper.loadKeyValuePairForEncoding(key, element, objectList, processed, arraySerializationFormat);
        }
    }

    private static void objectToList(String objName, Map<?, ?> obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, ArraySerializationFormat arraySerializationFormat) {
        Map<?, ?> map = obj;
        for (Map.Entry<?, ?> pair : map.entrySet()) {
            String attribName = pair.getKey().toString();
            if (objName != null && !objName.isEmpty()) {
                attribName = String.format("%s[%s]", objName, attribName);
            }
            CoreHelper.loadKeyValuePairForEncoding(attribName, pair.getValue(), objectList, processed, arraySerializationFormat);
        }
    }

    private static void objectToList(String objName, Object obj, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, ArraySerializationFormat arraySerializationFormat) {
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        TypeCombinator.TypeCombinatorCase typeCombinatorAnnotation = clazz.getAnnotation(TypeCombinator.TypeCombinatorCase.class);
        if (!CoreHelper.isWrapperType(clazz) && typeCombinatorAnnotation == null) {
            if (processed.contains(objName.hashCode())) {
                return;
            }
            processed.add(objName.hashCode());
        }
        if (obj instanceof Collection) {
            CoreHelper.objectToList(objName, (Collection)obj, objectList, processed, arraySerializationFormat);
        } else if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            int index = 0;
            for (Object element : array) {
                String key = String.format("%s[%d]", objName, index++);
                CoreHelper.loadKeyValuePairForEncoding(key, element, objectList, processed, arraySerializationFormat);
            }
        } else if (obj instanceof Map) {
            CoreHelper.objectToList(objName, (Map)obj, objectList, processed, arraySerializationFormat);
        } else {
            if (typeCombinatorAnnotation != null) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (field.getName() == "$jacocoData") continue;
                    Object fieldValue = null;
                    Object serializeAnnotation = null;
                    try {
                        field.setAccessible(true);
                        fieldValue = field.get(obj);
                        serializeAnnotation = field.getAnnotation(JsonSerialize.class);
                        if (serializeAnnotation == null) {
                            serializeAnnotation = field.getAnnotation(TypeCombinator.FormSerialize.class);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException key) {
                        // empty catch block
                    }
                    if (serializeAnnotation != null) {
                        if (serializeAnnotation instanceof JsonSerialize) {
                            CoreHelper.loadKeyValuePairForEncoding(objName, fieldValue, objectList, processed, serializeAnnotation, arraySerializationFormat);
                            continue;
                        }
                        CoreHelper.loadKeyValuePairForEncoding(objName, fieldValue, objectList, processed, (TypeCombinator.FormSerialize)serializeAnnotation, arraySerializationFormat);
                        continue;
                    }
                    CoreHelper.loadKeyValuePairForEncoding(objName, fieldValue, objectList, processed, arraySerializationFormat);
                }
                return;
            }
            while (clazz != null) {
                for (Method method : clazz.getDeclaredMethods()) {
                    JsonGetter getterAnnotation;
                    if (method.getParameterTypes().length != 0 || Modifier.isPrivate(method.getModifiers()) || !method.getName().startsWith("get") && !method.getName().startsWith("internalGet") || (getterAnnotation = method.getAnnotation(JsonGetter.class)) == null) continue;
                    String attribName = getterAnnotation.value();
                    if (objName != null && !objName.isEmpty()) {
                        attribName = String.format("%s[%s]", objName, attribName);
                    }
                    try {
                        method.setAccessible(true);
                        Object value = method.invoke(obj, new Object[0]);
                        JsonSerialize serializerAnnotation = method.getAnnotation(JsonSerialize.class);
                        if (serializerAnnotation != null) {
                            CoreHelper.loadKeyValuePairForEncoding(attribName, value, objectList, processed, serializerAnnotation, arraySerializationFormat);
                            continue;
                        }
                        CoreHelper.loadKeyValuePairForEncoding(attribName, value, objectList, processed, arraySerializationFormat);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        // empty catch block
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    private static String getAccessorStringFormat(ArraySerializationFormat arraySerializationFormat) {
        switch (arraySerializationFormat) {
            case CSV: {
                return CSV_FORMAT;
            }
            case PSV: {
                return PSV_FORMAT;
            }
            case TSV: {
                return TSV_FORMAT;
            }
        }
        return "";
    }

    private static boolean isDelimeterFormat(ArraySerializationFormat arraySerializationFormat) {
        return arraySerializationFormat == ArraySerializationFormat.CSV || arraySerializationFormat == ArraySerializationFormat.TSV || arraySerializationFormat == ArraySerializationFormat.PSV;
    }

    private static void loadKeyValueUsingSerializer(String key, Object value, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, JsonSerializer<?> serializer, ArraySerializationFormat arraySerializationFormat) throws JsonProcessingException {
        Object obj = CoreHelper.deserializeAsObject((value = CoreHelper.serialize(value, serializer)).toString());
        if (obj instanceof List || obj instanceof Map) {
            CoreHelper.loadKeyValuePairForEncoding(key, obj, objectList, processed, arraySerializationFormat);
        } else {
            if (value.toString().startsWith("\"")) {
                value = value.toString().substring(1, value.toString().length() - 1);
            }
            objectList.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
        }
    }

    private static void loadKeyValuePairForEncoding(String key, Object value, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, TypeCombinator.FormSerialize formSerializerAnnotation, ArraySerializationFormat arraySerializationFormat) {
        if (value == null) {
            return;
        }
        try {
            JsonSerializer<?> serializer = CoreHelper.getCollectionCustomSerializer(formSerializerAnnotation);
            CoreHelper.loadKeyValueUsingSerializer(key, value, objectList, processed, serializer, arraySerializationFormat);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private static void loadKeyValuePairForEncoding(String key, Object value, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, ArraySerializationFormat arraySerializationFormat) {
        if (value == null) {
            return;
        }
        if (CoreHelper.isWrapperType(value)) {
            objectList.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
        } else if (value instanceof CoreJsonObject) {
            CoreHelper.objectToList(key, ((CoreJsonObject)value).getStoredObject(), objectList, processed, arraySerializationFormat);
        } else if (value instanceof CoreJsonValue) {
            Object storedValue = ((CoreJsonValue)value).getStoredObject();
            if (CoreHelper.isWrapperType(storedValue)) {
                objectList.add(new AbstractMap.SimpleEntry<String, Object>(key, storedValue));
            } else {
                CoreHelper.objectToList(key, storedValue, objectList, processed, arraySerializationFormat);
            }
        } else if (value instanceof UUID) {
            objectList.add(new AbstractMap.SimpleEntry<String, String>(key, value.toString()));
        } else {
            CoreHelper.objectToList(key, value, objectList, processed, arraySerializationFormat);
        }
    }

    private static void loadKeyValuePairForEncoding(String key, Object value, List<AbstractMap.SimpleEntry<String, Object>> objectList, HashSet<Integer> processed, JsonSerialize serializerAnnotation, ArraySerializationFormat arraySerializationFormat) {
        if (value == null) {
            return;
        }
        try {
            JsonSerializer<?> serializer = CoreHelper.getSerializer(serializerAnnotation);
            if (serializer == null) {
                serializer = CoreHelper.getCollectionSerializer(serializerAnnotation);
            }
            CoreHelper.loadKeyValueUsingSerializer(key, value, objectList, processed, serializer, arraySerializationFormat);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private static boolean isWrapperType(Object object) {
        if (object == null) {
            return false;
        }
        return WRAPPER_TYPES.contains(object.getClass()) || object.getClass().isPrimitive() || object.getClass().isEnum();
    }

    public static String serializeEnumContainer(Object value) throws JsonProcessingException {
        if (value instanceof String || value instanceof Integer) {
            return String.valueOf(value);
        }
        return CoreHelper.serialize(value);
    }

    static {
        mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).withConfigOverride(BigDecimal.class, mutableConfigOverride -> mutableConfigOverride.setFormat(JsonFormat.Value.forShape((JsonFormat.Shape)JsonFormat.Shape.STRING)))).build();
        strictMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, true)).configure(MapperFeature.ALLOW_COERCION_OF_SCALARS, false)).addModule((Module)new SimpleModule().addDeserializer(String.class, (JsonDeserializer)new CoercionLessStringDeserializer()))).withConfigOverride(BigDecimal.class, mutableConfigOverride -> mutableConfigOverride.setFormat(JsonFormat.Value.forShape((JsonFormat.Shape)JsonFormat.Shape.STRING)))).build();
        WRAPPER_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, String.class, Integer.class, Long.class, Float.class, Double.class, BigDecimal.class, Void.class, File.class, MultipartWrapper.class, MultipartFileWrapper.class));
    }

    private static class CoercionLessStringDeserializer
    extends StringDeserializer {
        private static final long serialVersionUID = 1L;

        private CoercionLessStringDeserializer() {
        }

        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.getCurrentToken() != JsonToken.VALUE_STRING) {
                String message = "Cannot coerce " + p.getCurrentToken() + " to String value";
                throw MismatchedInputException.from((JsonParser)p, String.class, (String)message);
            }
            return super.deserialize(p, ctxt);
        }
    }
}

