/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core;

import esa.commons.Checks;
import esa.commons.collection.MultiMaps;
import esa.commons.collection.MultiValueMap;
import io.esastack.commons.net.buffer.Buffer;
import io.esastack.commons.net.http.HttpMethod;
import io.esastack.httpclient.core.FileRequest;
import io.esastack.httpclient.core.Handle;
import io.esastack.httpclient.core.Handler;
import io.esastack.httpclient.core.HttpClientBuilder;
import io.esastack.httpclient.core.HttpRequestBaseImpl;
import io.esastack.httpclient.core.HttpRequestFacade;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.MultipartBody;
import io.esastack.httpclient.core.MultipartBodyImpl;
import io.esastack.httpclient.core.MultipartFileItem;
import io.esastack.httpclient.core.MultipartRequest;
import io.esastack.httpclient.core.PlainRequest;
import io.esastack.httpclient.core.SegmentRequest;
import io.esastack.httpclient.core.netty.NettyHttpClient;
import io.esastack.httpclient.core.util.MultiValueMapUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CompositeRequest
extends HttpRequestBaseImpl
implements PlainRequest,
FileRequest,
MultipartRequest,
HttpRequestFacade {
    private static final byte STATE_INIT = -1;
    private static final byte STATE_PLAIN_PREPARING = 0;
    private static final byte STATE_MULTIPART_PREPARING = 1;
    private static final byte STATE_SEGMENT_PREPARING = 2;
    private static final byte STATE_FILE_PREPARING = 3;
    private static final byte STATE_PLAIN_EXECUTED = 4;
    private static final byte STATE_MULTIPART_EXECUTED = 5;
    private static final byte STATE_SEGMENT_EXECUTED = 6;
    private static final byte STATE_FILE_EXECUTED = 7;
    private final Object monitor = new Object();
    private final NettyHttpClient client;
    private final Supplier<SegmentRequest> request;
    private MultipartBody multipartBody;
    private Buffer buffer;
    private File file;
    private volatile byte status = (byte)-1;

    public CompositeRequest(HttpClientBuilder builder, NettyHttpClient client, Supplier<SegmentRequest> request, HttpMethod method, String uri) {
        super(builder, method, uri);
        Checks.checkNotNull((Object)client, (String)"client");
        Checks.checkNotNull(request, (String)"request");
        this.client = client;
        this.request = request;
    }

    @Override
    public CompletableFuture<HttpResponse> execute() {
        byte newStatus = this.status >= 0 ? (byte)(this.status + 4) : (byte)4;
        this.checkNotStartedAndUpdateStatus(newStatus);
        return this.client.execute(this, this.ctx, this.handle, this.handler);
    }

    @Override
    public PlainRequest body(Buffer data) {
        this.checkNotStartedAndUpdateStatus((byte)0);
        this.buffer = data;
        return this.self();
    }

    @Override
    public MultipartRequest multipart() {
        this.checkNotStartedAndUpdateStatus((byte)1);
        this.multipartBody = new MultipartBodyImpl();
        return this;
    }

    @Override
    public MultipartRequest multipart(MultipartBody multipartBody) {
        this.checkNotStartedAndUpdateStatus((byte)1);
        this.multipartBody = multipartBody;
        return this;
    }

    @Override
    public SegmentRequest segment() {
        this.checkNotStartedAndUpdateStatus((byte)2);
        SegmentRequest segment = this.request.get();
        HttpRequestBaseImpl.copyTo(this, (HttpRequestBaseImpl)((Object)segment));
        return segment;
    }

    @Override
    public FileRequest body(File file) {
        Checks.checkNotNull((Object)file, (String)"file");
        this.checkNotStartedAndUpdateStatus((byte)3);
        this.file = file;
        return this.self();
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public MultipartRequest multipartEncode(boolean useMultipartEncode) {
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.multipartEncode(useMultipartEncode);
        return this.self();
    }

    @Override
    public boolean multipartEncode() {
        if (!this.isMultipart()) {
            return false;
        }
        this.checkMultipartBodyNotNull();
        return this.multipartBody.multipartEncode();
    }

    @Override
    public MultipartRequest attr(String name, String value) {
        if (CompositeRequest.illegalArgs(name, value)) {
            return this.self();
        }
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.attr(name, value);
        return this.self();
    }

    @Override
    public MultipartRequest attrs(Map<String, String> attrMap) {
        Checks.checkNotNull(attrMap, (String)"attrMap");
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.attrs(attrMap);
        return this.self();
    }

    @Override
    public MultipartRequest attrs(MultiValueMap<String, String> values) {
        if (values == null || values.isEmpty()) {
            return this.self();
        }
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.attrs(values);
        return this.self();
    }

    @Override
    public MultipartRequest file(String name, File file) {
        if (CompositeRequest.illegalArgs(name, file)) {
            return this.self();
        }
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.file(name, file);
        return this.self();
    }

    @Override
    public MultipartRequest file(String name, File file, String contentType) {
        if (CompositeRequest.illegalArgs(name, file)) {
            return this.self();
        }
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.file(name, file, contentType);
        return this.self();
    }

    @Override
    public MultipartRequest file(String name, File file, String contentType, boolean isText) {
        if (CompositeRequest.illegalArgs(name, file)) {
            return this.self();
        }
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.file(name, file, contentType, isText);
        return this.self();
    }

    @Override
    public MultipartRequest file(String name, String filename, File file, String contentType, boolean isText) {
        if (CompositeRequest.illegalArgs(name, file)) {
            return this.self();
        }
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.file(name, filename, file, contentType, isText);
        return this.self();
    }

    @Override
    public MultipartRequest files(List<MultipartFileItem> files) {
        if (files == null || files.isEmpty()) {
            return this.self();
        }
        this.checkStarted();
        this.checkMultipartBodyNotNull();
        this.multipartBody.files(files);
        return this.self();
    }

    @Override
    public MultiValueMap<String, String> attrs() {
        if (this.multipartBody == null) {
            return MultiMaps.emptyMultiMap();
        }
        MultiValueMap<String, String> attrs = this.multipartBody.attrs();
        if (attrs != null && (this.status == 1 || this.status == 5)) {
            return MultiValueMapUtils.unmodifiableMap(attrs);
        }
        return MultiMaps.emptyMultiMap();
    }

    @Override
    public List<MultipartFileItem> files() {
        if (this.multipartBody == null) {
            return Collections.emptyList();
        }
        List<MultipartFileItem> files = this.multipartBody.files();
        if (files != null && (this.status == 1 || this.status == 5)) {
            return Collections.unmodifiableList(files);
        }
        return Collections.emptyList();
    }

    @Override
    public CompositeRequest enableUriEncode() {
        this.checkStarted();
        super.enableUriEncode();
        return this.self();
    }

    @Override
    public CompositeRequest disableExpectContinue() {
        this.checkStarted();
        super.disableExpectContinue();
        return this.self();
    }

    @Override
    public CompositeRequest maxRedirects(int maxRedirects) {
        this.checkStarted();
        super.maxRedirects(maxRedirects);
        return this.self();
    }

    @Override
    public CompositeRequest maxRetries(int maxRetries) {
        this.checkStarted();
        super.maxRetries(maxRetries);
        return this.self();
    }

    @Override
    public CompositeRequest readTimeout(long readTimeout) {
        this.checkStarted();
        super.readTimeout(readTimeout);
        return this.self();
    }

    @Override
    public CompositeRequest addHeader(CharSequence name, CharSequence value) {
        super.addHeader(name, value);
        return this.self();
    }

    @Override
    public CompositeRequest addHeaders(Map<? extends CharSequence, ? extends CharSequence> headers) {
        super.addHeaders((Map)headers);
        return this.self();
    }

    @Override
    public CompositeRequest setHeader(CharSequence name, CharSequence value) {
        super.setHeader(name, value);
        return this.self();
    }

    @Override
    public CompositeRequest removeHeader(CharSequence name) {
        super.removeHeader(name);
        return this.self();
    }

    @Override
    public CompositeRequest addParam(String name, String value) {
        this.checkStarted();
        super.addParam(name, value);
        return this.self();
    }

    @Override
    public CompositeRequest addParams(Map<String, String> params) {
        this.checkStarted();
        super.addParams((Map)params);
        return this.self();
    }

    @Override
    public CompositeRequest handle(Consumer<Handle> handle) {
        this.checkStarted();
        super.handle(handle);
        return this.self();
    }

    @Override
    public CompositeRequest handler(Handler handler) {
        this.checkStarted();
        super.handler(handler);
        return this.self();
    }

    @Override
    public boolean isSegmented() {
        return this.status == 2 || this.status == 6;
    }

    @Override
    public boolean isMultipart() {
        return this.status == 1 || this.status == 5;
    }

    @Override
    public boolean isFile() {
        return this.status == 3 || this.status == 7;
    }

    @Override
    public CompositeRequest copy() {
        CompositeRequest copied = new CompositeRequest(this.builder, this.client, this.request, this.method(), this.uri().toString());
        CompositeRequest.copyTo(this, copied);
        if (this.multipartBody != null) {
            copied.multipartBody = (MultipartBody)this.multipartBody.copy();
        }
        if (this.buffer != null) {
            copied.body(this.buffer.copy());
        }
        if (this.file != null) {
            copied.body(this.file);
        }
        copied.status = this.status >= 4 ? (byte)(this.status - 4) : this.status;
        return copied;
    }

    private void checkStarted() {
        if (this.status >= 4) {
            throw new IllegalStateException("Request's execute() has been called  and the modification isn't allowed");
        }
    }

    private void checkMultipartBodyNotNull() {
        if (this.multipartBody == null) {
            throw new IllegalStateException("MultipartBody is null,please call multipart() or multipart(multipartBody) firstly");
        }
    }

    private CompositeRequest self() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotStartedAndUpdateStatus(byte newStatus) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.status >= 4) {
                throw new IllegalStateException("The execute() has been called before");
            }
            if (this.status != -1 && newStatus < 4) {
                throw new IllegalStateException(this.decideType() + " request has been set before");
            }
            this.status = newStatus;
        }
    }

    private String decideType() {
        switch (this.status) {
            case 1: {
                return "MULTIPART";
            }
            case 2: {
                return "SEGMENT";
            }
            case 3: {
                return "FILE";
            }
        }
        return "PLAIN";
    }

    private static boolean illegalArgs(Object obj1, Object obj2) {
        return obj1 == null || obj2 == null;
    }

    public String toString() {
        return this.uri().toString();
    }
}

