/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core;

import esa.commons.Checks;
import io.esastack.commons.net.http.HttpVersion;
import io.esastack.httpclient.core.HttpClient;
import io.esastack.httpclient.core.Reusable;
import io.esastack.httpclient.core.config.CacheOptions;
import io.esastack.httpclient.core.config.Decompression;
import io.esastack.httpclient.core.config.Http1Options;
import io.esastack.httpclient.core.config.Http2Options;
import io.esastack.httpclient.core.config.NetOptions;
import io.esastack.httpclient.core.config.RetryOptions;
import io.esastack.httpclient.core.config.SslOptions;
import io.esastack.httpclient.core.exec.ExpectContinueInterceptor;
import io.esastack.httpclient.core.exec.FilteringExec;
import io.esastack.httpclient.core.exec.Interceptor;
import io.esastack.httpclient.core.exec.RedirectInterceptor;
import io.esastack.httpclient.core.exec.RetryInterceptor;
import io.esastack.httpclient.core.filter.DuplexFilter;
import io.esastack.httpclient.core.filter.RequestFilter;
import io.esastack.httpclient.core.filter.ResponseFilter;
import io.esastack.httpclient.core.netty.CachedChannelPools;
import io.esastack.httpclient.core.netty.NettyHttpClient;
import io.esastack.httpclient.core.resolver.HostResolver;
import io.esastack.httpclient.core.resolver.SystemDefaultResolver;
import io.esastack.httpclient.core.spi.ChannelPoolOptionsProvider;
import io.esastack.httpclient.core.spi.DuplexFilterFactory;
import io.esastack.httpclient.core.spi.InterceptorFactory;
import io.esastack.httpclient.core.spi.RequestFilterFactory;
import io.esastack.httpclient.core.spi.ResponseFilterFactory;
import io.esastack.httpclient.core.util.OrderedComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class HttpClientBuilder
implements Reusable<HttpClientBuilder> {
    private static final HostResolver DEFAULT_RESOLVER = new SystemDefaultResolver();
    private static final ChannelPoolOptionsProvider NULL_CHANNEL_OPTIONS = address -> null;
    private boolean keepAlive = true;
    private boolean useDecompress = false;
    private Decompression decompression = Decompression.GZIP_DEFLATE;
    private HostResolver resolver = DEFAULT_RESOLVER;
    private HttpVersion version = HttpVersion.HTTP_1_1;
    private long maxContentLength = -1L;
    private int idleTimeoutSeconds = -1;
    private long readTimeout = 6000L;
    private boolean h2ClearTextUpgrade = true;
    private int connectTimeout = 3000;
    private int connectionPoolSize = 512;
    private int connectionPoolWaitingQueueLength = 256;
    private int maxRedirects = 5;
    private SslOptions sslOptions;
    private NetOptions netOptions;
    private Http1Options http1Options;
    private Http2Options http2Options;
    private RetryOptions retryOptions = RetryOptions.ofDefault();
    private boolean useExpectContinue = false;
    private ChannelPoolOptionsProvider channelPoolOptionsProvider = NULL_CHANNEL_OPTIONS;
    private final List<Interceptor> interceptors = new LinkedList<Interceptor>();
    private final List<RequestFilter> requestFilters = new LinkedList<RequestFilter>();
    private final List<ResponseFilter> responseFilters = new LinkedList<ResponseFilter>();
    private Interceptor[] unmodifiableInterceptors;

    public HttpClientBuilder resolver(HostResolver resolver) {
        this.resolver = resolver;
        return this.self();
    }

    public HttpClientBuilder h2ClearTextUpgrade(boolean h2ClearTextUpgrade) {
        this.h2ClearTextUpgrade = h2ClearTextUpgrade;
        return this.self();
    }

    public HttpClientBuilder connectTimeout(int timeout) {
        Checks.checkArg((timeout > 0 ? 1 : 0) != 0, (String)"connectTimeout must greater than 0");
        this.connectTimeout = timeout;
        return this.self();
    }

    public HttpClientBuilder idleTimeoutSeconds(int idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
        return this.self();
    }

    public HttpClientBuilder readTimeout(long timeout) {
        Checks.checkArg((timeout > 0L ? 1 : 0) != 0, (String)"readTimeout must greater than 0");
        this.readTimeout = timeout;
        return this.self();
    }

    public HttpClientBuilder maxContentLength(long maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this.self();
    }

    public HttpClientBuilder keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this.self();
    }

    public HttpClientBuilder version(HttpVersion version) {
        Checks.checkNotNull((Object)version, (String)"version");
        this.version = version;
        return this.self();
    }

    public HttpClientBuilder connectionPoolSize(int size) {
        Checks.checkArg((size >= 1 ? 1 : 0) != 0, (String)("poolSize is " + size + " (expected >= 1)"));
        this.connectionPoolSize = size;
        return this.self();
    }

    public HttpClientBuilder connectionPoolWaitingQueueLength(int queueSize) {
        Checks.checkArg((queueSize >= 1 ? 1 : 0) != 0, (String)("waitingQueueLength is " + queueSize + " (expected >= 1)"));
        this.connectionPoolWaitingQueueLength = queueSize;
        return this.self();
    }

    public HttpClientBuilder useDecompress(boolean useDecompress) {
        this.useDecompress = useDecompress;
        return this.self();
    }

    public HttpClientBuilder decompression(Decompression decompression) {
        Checks.checkNotNull((Object)((Object)decompression), (String)"decompression");
        this.decompression = decompression;
        return this.self();
    }

    public HttpClientBuilder useExpectContinue(boolean useExpectContinue) {
        this.useExpectContinue = useExpectContinue;
        return this.self();
    }

    public boolean isUseExpectContinue() {
        return this.useExpectContinue;
    }

    public HttpClientBuilder addInterceptor(Interceptor interceptor) {
        Checks.checkNotNull((Object)interceptor, (String)"interceptor");
        this.interceptors.add(interceptor);
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder addInterceptors(List<Interceptor> interceptors) {
        Checks.checkNotNull(interceptors, (String)"interceptors");
        this.interceptors.addAll(interceptors);
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder addRequestFilter(RequestFilter filter) {
        Checks.checkNotNull((Object)filter, (String)"filter");
        this.requestFilters.add(filter);
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder addRequestFilters(List<RequestFilter> filters) {
        Checks.checkNotNull(filters, (String)"filters");
        this.requestFilters.addAll(filters);
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder addResponseFilter(ResponseFilter filter) {
        Checks.checkNotNull((Object)filter, (String)"filter");
        this.responseFilters.add(filter);
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder addResponseFilters(List<ResponseFilter> filters) {
        Checks.checkNotNull(filters, (String)"filters");
        this.responseFilters.addAll(filters);
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder addFilter(DuplexFilter filter) {
        Checks.checkNotNull((Object)filter, (String)"filter");
        this.requestFilters.add(filter);
        this.responseFilters.add(filter);
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder addFilters(List<DuplexFilter> filters) {
        Checks.checkNotNull(filters, (String)"filters");
        this.requestFilters.addAll(filters);
        this.responseFilters.addAll(filters);
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder channelPoolOptionsProvider(ChannelPoolOptionsProvider channelPoolOptionsProvider) {
        this.channelPoolOptionsProvider = channelPoolOptionsProvider;
        return this.self();
    }

    public HttpClientBuilder sslOptions(SslOptions sslOptions) {
        this.sslOptions = sslOptions;
        return this.self();
    }

    public HttpClientBuilder netOptions(NetOptions netOptions) {
        this.netOptions = netOptions;
        return this.self();
    }

    public HttpClientBuilder http1Options(Http1Options http1Options) {
        this.http1Options = http1Options;
        return this.self();
    }

    public HttpClientBuilder http2Options(Http2Options http2Options) {
        this.http2Options = http2Options;
        return this.self();
    }

    public HttpClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        return this.self();
    }

    public HttpClientBuilder maxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this.self();
    }

    public HostResolver resolver() {
        return this.resolver == null ? DEFAULT_RESOLVER : this.resolver;
    }

    public boolean isH2ClearTextUpgrade() {
        return this.h2ClearTextUpgrade;
    }

    private HttpClientBuilder self() {
        return this;
    }

    public HttpClient build() {
        return new NettyHttpClient(this.copy(), new CachedChannelPools(CacheOptions.ofDefault()));
    }

    @Override
    public HttpClientBuilder copy() {
        return new HttpClientBuilder().useDecompress(this.useDecompress).decompression(this.decompression).resolver(this.resolver).h2ClearTextUpgrade(this.h2ClearTextUpgrade).useExpectContinue(this.useExpectContinue).connectTimeout(this.connectTimeout).idleTimeoutSeconds(this.idleTimeoutSeconds).readTimeout(this.readTimeout).maxContentLength(this.maxContentLength).keepAlive(this.keepAlive).version(this.version).maxRedirects(this.maxRedirects).connectionPoolSize(this.connectionPoolSize).connectionPoolWaitingQueueLength(this.connectionPoolWaitingQueueLength).sslOptions(Reusable.copyOf(this.sslOptions)).netOptions(Reusable.copyOf(this.netOptions)).http1Options(Reusable.copyOf(this.http1Options)).http2Options(Reusable.copyOf(this.http2Options)).retryOptions(Reusable.copyOf(this.retryOptions)).channelPoolOptionsProvider(this.channelPoolOptionsProvider).addInterceptors(this.interceptors).addRequestFilters(this.requestFilters).addResponseFilters(this.responseFilters);
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public long readTimeout() {
        return this.readTimeout;
    }

    public long maxContentLength() {
        return this.maxContentLength;
    }

    public int idleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpVersion version() {
        return this.version;
    }

    public int connectionPoolSize() {
        return this.connectionPoolSize;
    }

    public int connectionPoolWaitingQueueLength() {
        return this.connectionPoolWaitingQueueLength;
    }

    public boolean isUseDecompress() {
        return this.useDecompress;
    }

    public Decompression decompression() {
        return this.decompression;
    }

    public ChannelPoolOptionsProvider channelPoolOptionsProvider() {
        return this.channelPoolOptionsProvider;
    }

    public SslOptions sslOptions() {
        return this.sslOptions;
    }

    public NetOptions netOptions() {
        return this.netOptions;
    }

    public Http1Options http1Options() {
        return this.http1Options;
    }

    public Http2Options http2Options() {
        return this.http2Options;
    }

    public List<Interceptor> interceptors() {
        return Collections.unmodifiableList(new ArrayList<Interceptor>(this.interceptors));
    }

    public List<RequestFilter> requestFilters() {
        return Collections.unmodifiableList(new ArrayList<RequestFilter>(this.requestFilters));
    }

    public List<ResponseFilter> responseFilters() {
        return Collections.unmodifiableList(new ArrayList<ResponseFilter>(this.responseFilters));
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public Interceptor[] unmodifiableInterceptors() {
        if (this.unmodifiableInterceptors == null) {
            this.unmodifiableInterceptors = this.buildUnmodifiableInterceptors();
        }
        return this.unmodifiableInterceptors;
    }

    public ResponseFilter[] buildUnmodifiableResponseFilters() {
        LinkedList<ResponseFilter> filters0 = new LinkedList<ResponseFilter>(this.responseFilters);
        filters0.addAll(ResponseFilterFactory.DEFAULT.filters());
        filters0.addAll(DuplexFilterFactory.DEFAULT.filters());
        OrderedComparator.sort(filters0);
        return Collections.unmodifiableList(filters0).toArray(new ResponseFilter[0]);
    }

    private Interceptor[] buildUnmodifiableInterceptors() {
        LinkedList<Interceptor> interceptors0 = new LinkedList<Interceptor>(this.interceptors);
        interceptors0.addAll(InterceptorFactory.DEFAULT.interceptors());
        if (this.retryOptions != null && HttpClientBuilder.absent(interceptors0, RetryInterceptor.class)) {
            interceptors0.add(new RetryInterceptor(this.retryOptions.predicate(), this.retryOptions.intervalMillis()));
        }
        if (HttpClientBuilder.absent(interceptors0, RedirectInterceptor.class)) {
            interceptors0.add(new RedirectInterceptor());
        }
        if (HttpClientBuilder.absent(interceptors0, ExpectContinueInterceptor.class)) {
            interceptors0.add(new ExpectContinueInterceptor());
        }
        if (HttpClientBuilder.absent(interceptors0, FilteringExec.class)) {
            interceptors0.add(new FilteringExec(this.buildUnmodifiableRequestFilters()));
        }
        OrderedComparator.sort(interceptors0);
        return Collections.unmodifiableList(interceptors0).toArray(new Interceptor[0]);
    }

    private RequestFilter[] buildUnmodifiableRequestFilters() {
        LinkedList<RequestFilter> filters0 = new LinkedList<RequestFilter>(this.requestFilters);
        filters0.addAll(RequestFilterFactory.DEFAULT.filters());
        filters0.addAll(DuplexFilterFactory.DEFAULT.filters());
        OrderedComparator.sort(filters0);
        return Collections.unmodifiableList(filters0).toArray(new RequestFilter[0]);
    }

    private static boolean absent(List<Interceptor> interceptors, Class<? extends Interceptor> target) {
        if (interceptors == null || interceptors.isEmpty()) {
            return true;
        }
        for (Interceptor interceptor : interceptors) {
            if (!target.isAssignableFrom(interceptor.getClass())) continue;
            return false;
        }
        return true;
    }
}

