/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core;

import esa.commons.Checks;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.http.HttpMethod;
import io.esastack.commons.net.netty.http.Http1HeadersImpl;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.Handle;
import io.esastack.httpclient.core.Handler;
import io.esastack.httpclient.core.HttpClientBuilder;
import io.esastack.httpclient.core.HttpRequestBase;
import io.esastack.httpclient.core.HttpUri;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class HttpRequestBaseImpl
implements HttpRequestBase {
    protected final Context ctx;
    protected final HttpClientBuilder builder;
    private final HttpUri uri;
    private final HttpMethod method;
    private final HttpHeaders headers = new Http1HeadersImpl();
    protected Consumer<Handle> handle;
    protected Handler handler;
    private long readTimeout;
    private boolean useUriEncode;

    protected HttpRequestBaseImpl(HttpClientBuilder builder, HttpMethod method, String uri) {
        Checks.checkNotNull((Object)builder, (String)"builder");
        Checks.checkNotEmptyArg((String)uri, (String)"uri");
        Checks.checkNotNull((Object)method, (String)"method");
        this.builder = builder;
        this.method = method;
        this.uri = new HttpUri(uri);
        this.ctx = new Context();
        this.readTimeout = builder.readTimeout();
        if (builder.retryOptions() != null) {
            this.ctx.maxRetries(builder.retryOptions().maxRetries());
        }
        this.ctx.maxRedirects(builder.maxRedirects());
        this.ctx.useExpectContinue(builder.isUseExpectContinue());
    }

    @Override
    public HttpRequestBase enableUriEncode() {
        this.useUriEncode = true;
        return this.self();
    }

    @Override
    public HttpRequestBase disableExpectContinue() {
        this.ctx.useExpectContinue(false);
        return this.self();
    }

    @Override
    public HttpRequestBase maxRedirects(int maxRedirects) {
        this.ctx.maxRedirects(maxRedirects);
        return this.self();
    }

    @Override
    public HttpRequestBase maxRetries(int maxRetries) {
        this.ctx.maxRetries(maxRetries);
        return this.self();
    }

    @Override
    public HttpRequestBase readTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        return this.self();
    }

    @Override
    public HttpRequestBase addHeaders(Map<? extends CharSequence, ? extends CharSequence> headers) {
        if (headers == null) {
            return this.self();
        }
        for (Map.Entry<? extends CharSequence, ? extends CharSequence> row : headers.entrySet()) {
            this.addHeader(row.getKey(), row.getValue());
        }
        return this.self();
    }

    @Override
    public HttpRequestBase addHeader(CharSequence name, CharSequence value) {
        if (HttpRequestBaseImpl.illegalArgs(name, value)) {
            return this.self();
        }
        this.headers.add(name, (Object)value);
        return this.self();
    }

    @Override
    public HttpRequestBase setHeader(CharSequence name, CharSequence value) {
        if (HttpRequestBaseImpl.illegalArgs(name, value)) {
            return this.self();
        }
        this.headers.set(name, (Object)value);
        return this.self();
    }

    @Override
    public HttpRequestBase removeHeader(CharSequence name) {
        this.headers.remove(name);
        return this.self();
    }

    @Override
    public HttpRequestBase addParams(Map<String, String> params) {
        if (params == null) {
            return this.self();
        }
        for (Map.Entry<String, String> row : params.entrySet()) {
            this.addParam(row.getKey(), row.getValue());
        }
        return this.self();
    }

    @Override
    public HttpRequestBase addParam(String name, String value) {
        if (HttpRequestBaseImpl.illegalArgs(name, value)) {
            return this.self();
        }
        this.uri.addParam(name, value);
        return this.self();
    }

    @Override
    public HttpRequestBase handle(Consumer<Handle> handle) {
        this.reset();
        this.handle = handle;
        return this.self();
    }

    @Override
    public HttpRequestBase handler(Handler handler) {
        this.reset();
        this.handler = handler;
        return this.self();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String scheme() {
        return this.uri.netURI().getScheme();
    }

    @Override
    public String path() {
        return this.uri.netURI().getPath();
    }

    @Override
    public HttpUri uri() {
        return this.uri;
    }

    @Override
    public String getParam(String name) {
        return this.uri.getParam(name);
    }

    @Override
    public List<String> getParams(String name) {
        List<String> values = this.uri.params(name);
        return values == null ? null : Collections.unmodifiableList(values);
    }

    @Override
    public Set<String> paramNames() {
        return Collections.unmodifiableSet(this.uri.paramNames());
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public CharSequence getHeader(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public long readTimeout() {
        return this.readTimeout;
    }

    @Override
    public boolean uriEncode() {
        return this.useUriEncode;
    }

    @Override
    public Context context() {
        return this.ctx;
    }

    @Override
    public HttpRequestBase copy() {
        HttpRequestBaseImpl copied = new HttpRequestBaseImpl(this.builder, this.method, this.uri.toString());
        HttpRequestBaseImpl.copyTo(this, copied);
        return copied;
    }

    protected static void copyTo(HttpRequestBaseImpl source, HttpRequestBaseImpl dest) {
        source.ctx.attrs().forEach((key, attr) -> dest.ctx.attrs().attr(key).set(attr.get()));
        source.uri().params().forEach(dest.uri::addParams);
        dest.ctx.useExpectContinue(source.ctx.isUseExpectContinue());
        dest.ctx.maxRedirects(source.ctx.maxRedirects());
        dest.ctx.maxRetries(source.ctx.maxRetries());
        dest.headers.add(source.headers);
        dest.handle(source.handle);
        dest.handler(source.handler);
        dest.readTimeout(source.readTimeout);
        if (source.useUriEncode) {
            dest.enableUriEncode();
        }
    }

    private HttpRequestBaseImpl self() {
        return this;
    }

    private void reset() {
        this.handler = null;
        this.handle = null;
    }

    private static boolean illegalArgs(Object obj1, Object obj2) {
        return obj1 == null || obj2 == null;
    }
}

