/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core;

import esa.commons.Checks;
import esa.commons.StringUtils;
import esa.commons.collection.HashMultiValueMap;
import esa.commons.collection.MultiValueMap;
import io.esastack.httpclient.core.util.LoggerUtils;
import io.esastack.httpclient.core.util.MultiValueMapUtils;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class HttpUri {
    private String rawUri;
    private URI uri;
    private final MultiValueMap<String, String> params;

    public HttpUri(String rawUri) {
        Checks.checkNotEmptyArg((String)rawUri, (String)"rawUri must not be empty");
        this.uri = URI.create(rawUri);
        this.rawUri = rawUri;
        this.params = new HashMultiValueMap();
    }

    public HttpUri(String rawUri, MultiValueMap<String, String> params) {
        Checks.checkNotEmptyArg((String)rawUri, (String)"rawUri must not be empty");
        this.uri = URI.create(rawUri);
        this.rawUri = rawUri;
        this.params = params == null ? new HashMultiValueMap() : new HashMultiValueMap(params);
    }

    public HttpUri(URI uri, MultiValueMap<String, String> params) {
        Checks.checkNotNull((Object)uri, (String)"uri");
        this.uri = uri;
        this.rawUri = uri.toString();
        this.params = params == null ? new HashMultiValueMap() : new HashMultiValueMap(params);
    }

    public void uri(String rawUri) {
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("The URI of the request is modified from {} to {}.", (Object)this.rawUri, (Object)rawUri);
        }
        this.rawUri = rawUri;
        this.uri = URI.create(rawUri);
    }

    public void uri(URI uri) {
        if (LoggerUtils.logger().isDebugEnabled()) {
            LoggerUtils.logger().debug("The URI of the request is modified from {} to {}.", (Object)this.rawUri, (Object)uri.toString());
        }
        this.rawUri = uri.toString();
        this.uri = uri;
    }

    public void addParam(String name, String value) {
        Checks.checkNotNull((Object)name, (String)"name");
        Checks.checkNotNull((Object)value, (String)"value");
        this.params.add((Object)name, (Object)value);
    }

    public void addParams(String name, List<String> values) {
        Checks.checkNotNull((Object)name, (String)"name");
        Checks.checkNotNull(values, (String)"values");
        this.params.addAll((Object)name, values);
    }

    public List<String> params(String name) {
        Checks.checkNotNull((Object)name, (String)"name");
        return (List)this.params.get((Object)name);
    }

    public String getParam(String name) {
        Checks.checkNotNull((Object)name, (String)"name");
        List values = (List)this.params.get((Object)name);
        return values == null || values.isEmpty() ? null : (String)values.get(0);
    }

    public Set<String> paramNames() {
        return this.params.keySet();
    }

    public MultiValueMap<String, String> params() {
        return this.params;
    }

    public MultiValueMap<String, String> unmodifiableParams() {
        return MultiValueMapUtils.unmodifiableMap(this.params());
    }

    public URI netURI() {
        return this.uri;
    }

    public String path() {
        return this.uri.getPath();
    }

    public String host() {
        return this.uri.getHost();
    }

    public int port() {
        return this.uri.getPort();
    }

    public String relative(boolean encode) {
        return encode ? this.encodeRelative() : this.spliceRelativeDirectly();
    }

    private String encodeRelative() {
        if (StringUtils.isNotEmpty((String)this.uri.getQuery())) {
            throw new IllegalArgumentException("query: " + this.uri.getRawQuery() + " is not allowed if you want to encode uri correctly, target uri: " + this.uri + ", please use addParam()!");
        }
        if (this.params().isEmpty() && StringUtils.isEmpty((String)this.uri.getQuery())) {
            return this.uri.getPath();
        }
        QueryStringEncoder encoder = new QueryStringEncoder(this.uri.getRawPath(), StandardCharsets.UTF_8);
        for (Map.Entry item : this.params().entrySet()) {
            if (((List)item.getValue()).isEmpty()) continue;
            for (String value : (List)item.getValue()) {
                encoder.addParam((String)item.getKey(), value);
            }
        }
        return encoder.toString();
    }

    private String spliceRelativeDirectly() {
        if (this.params().isEmpty()) {
            if (StringUtils.isEmpty((String)this.uri.getRawQuery())) {
                return this.uri.getPath();
            }
            return this.uri.getRawPath() + "?" + this.uri.getRawQuery();
        }
        StringBuilder target = new StringBuilder(this.uri.getRawPath()).append("?");
        if (StringUtils.isNotEmpty((String)this.uri.getRawQuery())) {
            target.append(this.uri.getRawQuery()).append("&");
        }
        for (Map.Entry item : this.params().entrySet()) {
            if (((List)item.getValue()).isEmpty()) continue;
            for (String value : (List)item.getValue()) {
                target.append((String)item.getKey()).append("=").append(value).append("&");
            }
        }
        return target.substring(0, target.length() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpUri uri1 = (HttpUri)o;
        return Objects.equals(this.rawUri, uri1.rawUri) && Objects.equals(this.params, uri1.params);
    }

    public int hashCode() {
        return Objects.hash(this.rawUri, this.params);
    }

    public String toString() {
        return this.rawUri;
    }
}

