/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core;

import esa.commons.annotation.Internal;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.HttpMessage;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.filter.FilterContext;
import java.net.SocketAddress;
import java.util.EventListener;

@Internal
public interface Listener
extends EventListener {
    default public void onInterceptorsStart(HttpRequest request, Context ctx) {
    }

    default public void onInterceptorsEnd(HttpRequest request, Context ctx) {
    }

    default public void onFiltersStart(HttpRequest request, FilterContext ctx) {
    }

    default public void onFiltersEnd(HttpRequest request, Context ctx) {
    }

    default public void onConnectionPoolAttempt(HttpRequest request, Context ctx, SocketAddress address) {
    }

    default public void onConnectionPoolAcquired(HttpRequest request, Context ctx, SocketAddress address) {
    }

    default public void onAcquireConnectionPoolFailed(HttpRequest request, Context ctx, SocketAddress address, Throwable cause) {
    }

    default public void onConnectionAttempt(HttpRequest request, Context ctx, SocketAddress address) {
    }

    default public void onConnectionAcquired(HttpRequest request, Context ctx, SocketAddress address) {
    }

    default public void onAcquireConnectionFailed(HttpRequest request, Context ctx, SocketAddress address, Throwable cause) {
    }

    default public void onWriteAttempt(HttpRequest request, Context ctx) {
    }

    default public void onWriteDone(HttpRequest request, Context ctx) {
    }

    default public void onWriteFailed(HttpRequest request, Context ctx, Throwable cause) {
    }

    default public void onMessageReceived(HttpRequest request, Context ctx, HttpMessage message) {
    }

    default public void onCompleted(HttpRequest request, Context ctx, HttpResponse response) {
    }

    default public void onError(HttpRequest request, Context ctx, Throwable cause) {
    }
}

