/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core;

import esa.commons.spi.SpiLoader;
import io.esastack.httpclient.core.Context;
import io.esastack.httpclient.core.HttpMessage;
import io.esastack.httpclient.core.HttpRequest;
import io.esastack.httpclient.core.HttpResponse;
import io.esastack.httpclient.core.Listener;
import io.esastack.httpclient.core.NoopListener;
import io.esastack.httpclient.core.filter.FilterContext;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;

public class ListenerProxy
implements Listener {
    public static final Listener DEFAULT;
    private final List<Listener> listeners;
    private final boolean listenersAbsent;

    public ListenerProxy(Listener delegate) {
        this.listeners = delegate == null ? Collections.emptyList() : Collections.singletonList(delegate);
        this.listenersAbsent = delegate == null;
    }

    ListenerProxy(List<Listener> delegate) {
        this.listeners = delegate == null ? Collections.emptyList() : Collections.unmodifiableList(delegate);
        this.listenersAbsent = delegate == null || delegate.isEmpty();
    }

    @Override
    public void onInterceptorsStart(HttpRequest request, Context ctx) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onInterceptorsStart(request, ctx);
        }
    }

    @Override
    public void onInterceptorsEnd(HttpRequest request, Context ctx) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onInterceptorsEnd(request, ctx);
        }
    }

    @Override
    public void onFiltersStart(HttpRequest request, FilterContext ctx) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onFiltersStart(request, ctx);
        }
    }

    @Override
    public void onFiltersEnd(HttpRequest request, Context ctx) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onFiltersEnd(request, ctx);
        }
    }

    @Override
    public void onConnectionPoolAttempt(HttpRequest request, Context ctx, SocketAddress address) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onConnectionPoolAttempt(request, ctx, address);
        }
    }

    @Override
    public void onConnectionPoolAcquired(HttpRequest request, Context ctx, SocketAddress address) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onConnectionPoolAcquired(request, ctx, address);
        }
    }

    @Override
    public void onAcquireConnectionPoolFailed(HttpRequest request, Context ctx, SocketAddress address, Throwable cause) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onAcquireConnectionPoolFailed(request, ctx, address, cause);
        }
    }

    @Override
    public void onConnectionAttempt(HttpRequest request, Context ctx, SocketAddress address) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onConnectionAttempt(request, ctx, address);
        }
    }

    @Override
    public void onConnectionAcquired(HttpRequest request, Context ctx, SocketAddress address) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onConnectionAcquired(request, ctx, address);
        }
    }

    @Override
    public void onAcquireConnectionFailed(HttpRequest request, Context ctx, SocketAddress address, Throwable cause) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onAcquireConnectionFailed(request, ctx, address, cause);
        }
    }

    @Override
    public void onWriteAttempt(HttpRequest request, Context ctx) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onWriteAttempt(request, ctx);
        }
    }

    @Override
    public void onWriteDone(HttpRequest request, Context ctx) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onWriteDone(request, ctx);
        }
    }

    @Override
    public void onWriteFailed(HttpRequest request, Context ctx, Throwable cause) {
        if (!this.listenersAbsent) {
            for (Listener listener : this.listeners) {
                listener.onWriteFailed(request, ctx, cause);
            }
        }
    }

    @Override
    public void onMessageReceived(HttpRequest request, Context ctx, HttpMessage message) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onMessageReceived(request, ctx, message);
        }
    }

    @Override
    public void onCompleted(HttpRequest request, Context ctx, HttpResponse response) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onCompleted(request, ctx, response);
        }
    }

    @Override
    public void onError(HttpRequest request, Context ctx, Throwable cause) {
        if (this.listenersAbsent) {
            return;
        }
        for (Listener listener : this.listeners) {
            listener.onError(request, ctx, cause);
        }
    }

    static {
        List ls = SpiLoader.getAll(Listener.class);
        DEFAULT = ls == null || ls.isEmpty() ? NoopListener.INSTANCE : new ListenerProxy(ls);
    }
}

