/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core;

import esa.commons.collection.HashMultiValueMap;
import esa.commons.collection.MultiValueMap;
import io.esastack.httpclient.core.MultipartBody;
import io.esastack.httpclient.core.MultipartConfigure;
import io.esastack.httpclient.core.MultipartFileItem;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultipartBodyImpl
implements MultipartBody {
    private MultiValueMap<String, String> attrs;
    private List<MultipartFileItem> files;
    private boolean useMultipartEncode = true;

    @Override
    public MultiValueMap<String, String> attrs() {
        return this.attrs;
    }

    @Override
    public List<MultipartFileItem> files() {
        return this.files;
    }

    @Override
    public MultipartBody multipartEncode(boolean multipartEncode) {
        this.useMultipartEncode = multipartEncode;
        return this.self();
    }

    @Override
    public MultipartBody attr(String name, String value) {
        this.checkAttrsNotNull();
        this.attrs.add((Object)name, (Object)value);
        return this.self();
    }

    @Override
    public MultipartBody attrs(MultiValueMap<String, String> values) {
        if (values == null || values.isEmpty()) {
            return this.self();
        }
        this.checkAttrsNotNull();
        for (Map.Entry entry : values.entrySet()) {
            this.attrs.addAll(entry.getKey(), (Iterable)entry.getValue());
        }
        return this.self();
    }

    @Override
    public MultipartConfigure attrs(Map<String, String> attrMap) {
        if (attrMap == null || attrMap.isEmpty()) {
            return this.self();
        }
        this.checkAttrsNotNull();
        for (Map.Entry<String, String> entry : attrMap.entrySet()) {
            this.attr(entry.getKey(), entry.getValue());
        }
        return this.self();
    }

    @Override
    public MultipartBody files(List<MultipartFileItem> files) {
        if (files == null || files.isEmpty()) {
            return this.self();
        }
        this.checkMultipartFile();
        this.checkFilesNotNull();
        this.files.addAll(files);
        return this.self();
    }

    @Override
    public MultipartBody file(String name, File file) {
        return this.files((List)Collections.singletonList(new MultipartFileItem(name, file)));
    }

    @Override
    public MultipartBody file(String name, File file, String contentType) {
        return this.files((List)Collections.singletonList(new MultipartFileItem(name, file, contentType)));
    }

    @Override
    public MultipartBody file(String name, File file, String contentType, boolean isText) {
        return this.files((List)Collections.singletonList(new MultipartFileItem(name, file, contentType, isText)));
    }

    @Override
    public MultipartBody file(String name, String filename, File file, String contentType, boolean isText) {
        return this.files((List)Collections.singletonList(new MultipartFileItem(name, filename, file, contentType, isText)));
    }

    @Override
    public boolean multipartEncode() {
        return this.useMultipartEncode;
    }

    private MultipartBody self() {
        return this;
    }

    private void checkAttrsNotNull() {
        if (this.attrs == null) {
            this.attrs = new HashMultiValueMap();
        }
    }

    private void checkMultipartFile() {
        if (!this.useMultipartEncode) {
            throw new IllegalStateException("File is not allowed to be added, maybe multipart is false?");
        }
    }

    private void checkFilesNotNull() {
        if (this.files == null) {
            this.files = new LinkedList<MultipartFileItem>();
        }
    }

    @Override
    public MultipartBody copy() {
        MultipartBodyImpl copied = new MultipartBodyImpl();
        if (this.attrs != null) {
            for (Map.Entry entry : this.attrs.entrySet()) {
                List values = (List)entry.getValue();
                if (values == null || values.isEmpty()) continue;
                for (String value : values) {
                    copied.attr((String)entry.getKey(), value);
                }
            }
        }
        if (this.files != null) {
            for (MultipartFileItem item : this.files) {
                copied.file(item.name(), item.fileName(), item.file(), item.contentType(), item.isText());
            }
        }
        copied.multipartEncode(this.useMultipartEncode);
        return copied;
    }
}

