/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core;

import esa.commons.Checks;
import java.io.File;

public class MultipartFileItem {
    static final String DEFAULT_BINARY_CONTENT_TYPE = "application/octet-stream";
    static final String DEFAULT_TEXT_CONTENT_TYPE = "text/plain";
    private final String name;
    private final String filename;
    private final File file;
    private final String contentType;
    private final boolean isText;

    public MultipartFileItem(String name, File file) {
        this(name, file.getName(), file, DEFAULT_BINARY_CONTENT_TYPE, false);
    }

    public MultipartFileItem(String name, File file, String contentType) {
        this(name, file.getName(), file, contentType, DEFAULT_TEXT_CONTENT_TYPE.equalsIgnoreCase(contentType));
    }

    public MultipartFileItem(String name, File file, String contentType, boolean isText) {
        this(name, file.getName(), file, contentType, isText);
    }

    public MultipartFileItem(String name, String filename, File file, String contentType, boolean isText) {
        Checks.checkNotNull((Object)name, (String)"name");
        Checks.checkNotNull((Object)filename, (String)"fileName");
        Checks.checkNotNull((Object)file, (String)"file");
        Checks.checkNotNull((Object)contentType, (String)"contentType");
        this.name = name;
        this.filename = filename;
        this.file = file;
        this.contentType = contentType;
        this.isText = isText;
    }

    public String name() {
        return this.name;
    }

    public String fileName() {
        return this.filename;
    }

    public File file() {
        return this.file;
    }

    public String contentType() {
        return this.contentType;
    }

    public boolean isText() {
        return this.isText;
    }
}

