/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.config;

import esa.commons.Checks;
import io.esastack.httpclient.core.Reusable;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.Serializable;
import java.util.StringJoiner;

public class CacheOptions
implements Reusable<CacheOptions>,
Serializable {
    private static final String INITIAL_CAPACITY_KEY = "io.esastack.httpclient.caching-connectionPools.initialCapacity";
    private static final String MAXIMUM_SIZE_KEY = "io.esastack.httpclient.caching-connectionPools.maximumSize";
    private static final String EXPIRE_SECONDS_KEY = "io.esastack.httpclient.caching-connectionPools.expireAfterAccess";
    private static final long serialVersionUID = -7207026123787537822L;
    private final int initialCapacity;
    private final long maximumSize;
    private final long expireSeconds;

    private CacheOptions(int initialCapacity, long maximumSize, long expireSeconds) {
        Checks.checkArg((initialCapacity >= 0 ? 1 : 0) != 0, (String)("initialCapacity is " + initialCapacity + " (expected >= 0)"));
        Checks.checkArg((maximumSize >= 0L ? 1 : 0) != 0, (String)("maximumSize is " + maximumSize + " (expected >= 0L)"));
        Checks.checkArg((expireSeconds >= 0L ? 1 : 0) != 0, (String)("expireSeconds is " + expireSeconds + " (expected >= 0L)"));
        this.initialCapacity = initialCapacity;
        this.maximumSize = maximumSize;
        this.expireSeconds = expireSeconds;
    }

    public static CacheOptions ofDefault() {
        return new CacheOptionsBuilder().build();
    }

    public static CacheOptionsBuilder options() {
        return new CacheOptionsBuilder();
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public long maximumSize() {
        return this.maximumSize;
    }

    public long expireSeconds() {
        return this.expireSeconds;
    }

    @Override
    public CacheOptions copy() {
        return new CacheOptions(this.initialCapacity, this.maximumSize, this.expireSeconds);
    }

    public String toString() {
        return new StringJoiner(", ", CacheOptions.class.getSimpleName() + "[", "]").add("initialCapacity=" + this.initialCapacity).add("maximumSize=" + this.maximumSize).add("expireSeconds=" + this.expireSeconds).toString();
    }

    public static class CacheOptionsBuilder {
        private static final int DEFAULT_INITIAL_CAPACITY = SystemPropertyUtil.getInt((String)"io.esastack.httpclient.caching-connectionPools.initialCapacity", (int)16);
        private static final long DEFAULT_MAXIMUM_SIZE = SystemPropertyUtil.getLong((String)"io.esastack.httpclient.caching-connectionPools.maximumSize", (long)512L);
        private static final long DEFAULT_EXPIRE_SECONDS = SystemPropertyUtil.getLong((String)"io.esastack.httpclient.caching-connectionPools.expireAfterAccess", (long)600L);
        private int initialCapacity = DEFAULT_INITIAL_CAPACITY;
        private long maximumSize = DEFAULT_MAXIMUM_SIZE;
        private long expireSeconds = DEFAULT_EXPIRE_SECONDS;

        CacheOptionsBuilder() {
        }

        public CacheOptionsBuilder initialCapacity(int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        public CacheOptionsBuilder maximumSize(long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public CacheOptionsBuilder expireSeconds(long expireSeconds) {
            this.expireSeconds = expireSeconds;
            return this;
        }

        public CacheOptions build() {
            return new CacheOptions(this.initialCapacity, this.maximumSize, this.expireSeconds);
        }
    }
}

