/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.config;

import esa.commons.Checks;
import io.esastack.httpclient.core.Reusable;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.Serializable;
import java.util.StringJoiner;

public class CallbackThreadPoolOptions
implements Reusable<CallbackThreadPoolOptions>,
Serializable {
    private static final String CALLBACK_EXECUTOR_CORE_SIZE = "io.esastack.httpclient.callbackExecutor.coreSize";
    private static final String CALLBACK_EXECUTOR_MAX_SIZE = "io.esastack.httpclient.callbackExecutor.maxSize";
    private static final String CALLBACK_EXECUTOR_BLOCKING_QUEUE_LENGTH = "io.esastack.httpclient.callbackExecutor.blockingQueueLength";
    private static final String CALLBACK_EXECUTOR_KEEP_ALIVE_SECONDS = "io.esastack.httpclient.callbackExecutor.keepAliveSeconds";
    private static final String CALLBACK_EXECUTOR_GRACEFULLY_SHUTDOWN_SECONDS = "io.esastack.httpclient.callbackExecutor.gracefullyShutdownSeconds";
    private static final long serialVersionUID = -8935787924275761416L;
    private final int coreSize;
    private final int maxSize;
    private final int blockingQueueLength;
    private final long keepAliveSeconds;
    private final long gracefullyShutdownSeconds;

    private CallbackThreadPoolOptions(int coreSize, int maxSize, int blockingQueueLength, long keepAliveSeconds, long gracefullyShutdownMillis) {
        Checks.checkArg((coreSize >= 0 ? 1 : 0) != 0, (String)("coreSize is " + coreSize + " (expected >= 0)"));
        Checks.checkArg((maxSize > 0 ? 1 : 0) != 0, (String)("maxSize is " + maxSize + " (expected > 0)"));
        Checks.checkArg((blockingQueueLength >= 0 ? 1 : 0) != 0, (String)("blockingQueueLength is " + blockingQueueLength + " (expected >= 0)"));
        Checks.checkArg((keepAliveSeconds >= 0L ? 1 : 0) != 0, (String)("keepAliveSeconds is " + keepAliveSeconds + " (expected >= 0L)"));
        Checks.checkArg((maxSize >= coreSize ? 1 : 0) != 0, (String)("coreSize is " + coreSize + ", maxSize is " + maxSize + " (expected maxSize >= coreSize)"));
        this.coreSize = coreSize;
        this.maxSize = maxSize;
        this.blockingQueueLength = blockingQueueLength;
        this.keepAliveSeconds = keepAliveSeconds;
        this.gracefullyShutdownSeconds = gracefullyShutdownMillis;
    }

    @Override
    public CallbackThreadPoolOptions copy() {
        return new CallbackThreadPoolOptions(this.coreSize, this.maxSize, this.blockingQueueLength, this.keepAliveSeconds, this.gracefullyShutdownSeconds);
    }

    public static CallbackThreadPoolOptions ofDefault() {
        return new CallbackThreadPoolOptionsBuilder().build();
    }

    public static CallbackThreadPoolOptionsBuilder options() {
        return new CallbackThreadPoolOptionsBuilder();
    }

    public int coreSize() {
        return this.coreSize;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int blockingQueueLength() {
        return this.blockingQueueLength;
    }

    public long keepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public long gracefullyShutdownSeconds() {
        return this.gracefullyShutdownSeconds;
    }

    public String toString() {
        return new StringJoiner(", ", CallbackThreadPoolOptions.class.getSimpleName() + "[", "]").add("coreSize=" + this.coreSize).add("maxSize=" + this.maxSize).add("blockingQueueLength=" + this.blockingQueueLength).add("keepAliveSeconds=" + this.keepAliveSeconds).add("gracefullyShutdownSeconds=" + this.gracefullyShutdownSeconds).toString();
    }

    public static class CallbackThreadPoolOptionsBuilder {
        private static final int DEFAULT_CORE_SIZE = SystemPropertyUtil.getInt((String)"io.esastack.httpclient.callbackExecutor.coreSize", (int)0);
        private static final int DEFAULT_MAX_SIZE = SystemPropertyUtil.getInt((String)"io.esastack.httpclient.callbackExecutor.maxSize", (int)0);
        private static final int DEFAULT_BLOCKING_QUEUE_LENGTH = SystemPropertyUtil.getInt((String)"io.esastack.httpclient.callbackExecutor.blockingQueueLength", (int)256);
        private static final long DEFAULT_KEEPALIVE_SECONDS = SystemPropertyUtil.getLong((String)"io.esastack.httpclient.callbackExecutor.keepAliveSeconds", (long)180L);
        private static final long DEFAULT_GRACEFULLY_SHUTDOWN_SECONDS = SystemPropertyUtil.getLong((String)"io.esastack.httpclient.callbackExecutor.gracefullyShutdownSeconds", (long)30L);
        private int coreSize = DEFAULT_CORE_SIZE;
        private int maxSize = DEFAULT_MAX_SIZE;
        private int blockingQueueLength = DEFAULT_BLOCKING_QUEUE_LENGTH;
        private long keepAliveSeconds = DEFAULT_KEEPALIVE_SECONDS;
        private long gracefullyShutdownSeconds = DEFAULT_GRACEFULLY_SHUTDOWN_SECONDS;

        CallbackThreadPoolOptionsBuilder() {
        }

        public CallbackThreadPoolOptionsBuilder coreSize(int coreSize) {
            this.coreSize = coreSize;
            return this;
        }

        public CallbackThreadPoolOptionsBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public CallbackThreadPoolOptionsBuilder blockingQueueLength(int blockingQueueLength) {
            this.blockingQueueLength = blockingQueueLength;
            return this;
        }

        public CallbackThreadPoolOptionsBuilder keepAliveSeconds(long keepAliveSeconds) {
            this.keepAliveSeconds = keepAliveSeconds;
            return this;
        }

        public CallbackThreadPoolOptionsBuilder gracefullyShutdownSeconds(long gracefullyShutdownSeconds) {
            this.gracefullyShutdownSeconds = gracefullyShutdownSeconds;
            return this;
        }

        public CallbackThreadPoolOptions build() {
            if (this.coreSize == 0 && this.maxSize == 0) {
                return null;
            }
            if (this.coreSize == 0) {
                this.coreSize = this.maxSize;
            } else if (this.maxSize == 0) {
                this.maxSize = this.coreSize;
            }
            return new CallbackThreadPoolOptions(this.coreSize, this.maxSize, this.blockingQueueLength, this.keepAliveSeconds, this.gracefullyShutdownSeconds);
        }
    }
}

