/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.config;

import esa.commons.Checks;
import io.esastack.httpclient.core.Reusable;
import java.io.Serializable;
import java.util.Objects;
import java.util.StringJoiner;

public class ChannelPoolOptions
implements Reusable<ChannelPoolOptions>,
Serializable {
    private static final long serialVersionUID = 802132190143196865L;
    private final long readTimeout;
    private final int connectTimeout;
    private final int poolSize;
    private final int waitingQueueLength;

    private ChannelPoolOptions(long readTimeout, int connectTimeout, int poolSize, int waitingQueueLength) {
        Checks.checkArg((readTimeout >= 1L ? 1 : 0) != 0, (String)("readTimeout is " + readTimeout + " (expected >= 1)"));
        Checks.checkArg((connectTimeout >= 1 ? 1 : 0) != 0, (String)("connectTimeout is " + connectTimeout + " (expected >= 1)"));
        Checks.checkArg((poolSize >= 1 ? 1 : 0) != 0, (String)("poolSize is " + poolSize + " (expected >= 1)"));
        Checks.checkArg((waitingQueueLength >= 1 ? 1 : 0) != 0, (String)("waitingQueueLength is " + waitingQueueLength + " (expected >= 1)"));
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.poolSize = poolSize;
        this.waitingQueueLength = waitingQueueLength;
    }

    @Override
    public ChannelPoolOptions copy() {
        return new ChannelPoolOptions(this.readTimeout, this.connectTimeout, this.poolSize, this.waitingQueueLength);
    }

    public static ChannelPoolOptions ofDefault() {
        return new ChannelPoolOptionsBuilder().build();
    }

    public static ChannelPoolOptionsBuilder options() {
        return new ChannelPoolOptionsBuilder();
    }

    public long readTimeout() {
        return this.readTimeout;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public int poolSize() {
        return this.poolSize;
    }

    public int waitingQueueLength() {
        return this.waitingQueueLength;
    }

    public String toString() {
        return new StringJoiner(", ", ChannelPoolOptions.class.getSimpleName() + "[", "]").add("readTimeout=" + this.readTimeout).add("connectTimeout=" + this.connectTimeout).add("poolSize=" + this.poolSize).add("waitingQueueLength=" + this.waitingQueueLength).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelPoolOptions options = (ChannelPoolOptions)o;
        return this.readTimeout == options.readTimeout && this.connectTimeout == options.connectTimeout && this.poolSize == options.poolSize && this.waitingQueueLength == options.waitingQueueLength;
    }

    public int hashCode() {
        return Objects.hash(this.readTimeout, this.connectTimeout, this.poolSize, this.waitingQueueLength);
    }

    public static class ChannelPoolOptionsBuilder {
        private long readTimeout = 6000L;
        private int connectTimeout = 3000;
        private int poolSize = 512;
        private int waitingQueueLength = 256;

        ChannelPoolOptionsBuilder() {
        }

        public ChannelPoolOptionsBuilder readTimeout(long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ChannelPoolOptionsBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ChannelPoolOptionsBuilder poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public ChannelPoolOptionsBuilder waitingQueueLength(int waitingQueueLength) {
            this.waitingQueueLength = waitingQueueLength;
            return this;
        }

        public ChannelPoolOptions build() {
            return new ChannelPoolOptions(this.readTimeout, this.connectTimeout, this.poolSize, this.waitingQueueLength);
        }
    }
}

