/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.config;

import esa.commons.Checks;
import io.esastack.httpclient.core.Reusable;
import java.io.Serializable;
import java.util.StringJoiner;

public class Http1Options
implements Reusable<Http1Options>,
Serializable {
    private static final long serialVersionUID = 84321473660029244L;
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final int maxChunkSize;

    private Http1Options(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        Checks.checkArg((maxInitialLineLength > 0 ? 1 : 0) != 0, (String)("maxInitialLineLength is " + maxInitialLineLength + " (expected > 0)"));
        Checks.checkArg((maxHeaderSize > 0 ? 1 : 0) != 0, (String)("maxHeaderSize is " + maxHeaderSize + " (expected > 0)"));
        Checks.checkArg((maxChunkSize > 0 ? 1 : 0) != 0, (String)("maxChunkSize is " + maxChunkSize + " (expected > 0)"));
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeaderSize = maxHeaderSize;
        this.maxChunkSize = maxChunkSize;
    }

    @Override
    public Http1Options copy() {
        return new Http1Options(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize);
    }

    public static Http1Options ofDefault() {
        return new Http1OptionsBuilder().build();
    }

    public static Http1OptionsBuilder options() {
        return new Http1OptionsBuilder();
    }

    public int maxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    public int maxChunkSize() {
        return this.maxChunkSize;
    }

    public String toString() {
        return new StringJoiner(", ", Http1Options.class.getSimpleName() + "[", "]").add("maxInitialLineLength=" + this.maxInitialLineLength).add("maxHeaderSize=" + this.maxHeaderSize).add("maxChunkSize=" + this.maxChunkSize).toString();
    }

    public static class Http1OptionsBuilder {
        private int maxInitialLineLength = 4096;
        private int maxHeaderSize = 8192;
        private int maxChunkSize = 8192;

        Http1OptionsBuilder() {
        }

        public Http1OptionsBuilder maxInitialLineLength(int maxInitialLineLength) {
            this.maxInitialLineLength = maxInitialLineLength;
            return this;
        }

        public Http1OptionsBuilder maxHeaderSize(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
            return this;
        }

        public Http1OptionsBuilder maxChunkSize(int maxChunkSize) {
            this.maxChunkSize = maxChunkSize;
            return this;
        }

        public Http1Options build() {
            return new Http1Options(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize);
        }
    }
}

