/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.config;

import esa.commons.Checks;
import io.esastack.httpclient.core.Reusable;
import io.netty.handler.codec.http2.Http2CodecUtil;
import java.io.Serializable;
import java.util.StringJoiner;

public class Http2Options
implements Reusable<Http2Options>,
Serializable {
    private static final long serialVersionUID = -2062493018634619158L;
    private final int maxReservedStreams;
    private final int maxFrameSize;
    private final long gracefulShutdownTimeoutMillis;

    private Http2Options(int maxReservedStreams, int maxFrameSize, long gracefulShutdownTimeoutMillis) {
        Checks.checkArg((maxReservedStreams >= 0 ? 1 : 0) != 0, (String)("maxReservedStreams is " + maxReservedStreams + " (expected >= 0)"));
        Checks.checkArg((boolean)Http2CodecUtil.isMaxFrameSizeValid((int)maxFrameSize), (String)"maxFrameSize is invalid");
        Checks.checkArg((gracefulShutdownTimeoutMillis >= -1L ? 1 : 0) != 0, (String)("gracefulShutdownTimeoutMillis is " + gracefulShutdownTimeoutMillis + " (expected > -1L)"));
        this.maxReservedStreams = maxReservedStreams;
        this.maxFrameSize = maxFrameSize;
        this.gracefulShutdownTimeoutMillis = gracefulShutdownTimeoutMillis;
    }

    public static Http2Options ofDefault() {
        return new Http2OptionsBuilder().build();
    }

    public static Http2OptionsBuilder options() {
        return new Http2OptionsBuilder();
    }

    public int maxReservedStreams() {
        return this.maxReservedStreams;
    }

    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    public long gracefulShutdownTimeoutMillis() {
        return this.gracefulShutdownTimeoutMillis;
    }

    @Override
    public Http2Options copy() {
        return new Http2Options(this.maxReservedStreams, this.maxFrameSize, this.gracefulShutdownTimeoutMillis);
    }

    public String toString() {
        return new StringJoiner(", ", Http2Options.class.getSimpleName() + "[", "]").add("maxReservedStreams=" + this.maxReservedStreams).add("maxFrameSize=" + this.maxFrameSize).add("gracefulShutdownTimeoutMillis=" + this.gracefulShutdownTimeoutMillis).toString();
    }

    public static class Http2OptionsBuilder {
        private int maxReservedStreams = 100;
        private int maxFrameSize = 16384;
        private long gracefulShutdownTimeoutMillis = 30000L;

        Http2OptionsBuilder() {
        }

        public Http2OptionsBuilder maxReservedStreams(int maxReservedStreams) {
            this.maxReservedStreams = maxReservedStreams;
            return this;
        }

        public Http2OptionsBuilder maxFrameSize(int maxFrameSize) {
            this.maxFrameSize = maxFrameSize;
            return this;
        }

        public Http2OptionsBuilder gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
            this.gracefulShutdownTimeoutMillis = gracefulShutdownTimeoutMillis;
            return this;
        }

        public Http2Options build() {
            return new Http2Options(this.maxReservedStreams, this.maxFrameSize, this.gracefulShutdownTimeoutMillis);
        }
    }
}

