/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.config;

import io.esastack.httpclient.core.Reusable;
import java.io.Serializable;
import java.util.StringJoiner;

public class NetOptions
implements Reusable<NetOptions>,
Serializable {
    private static final long serialVersionUID = 6352915710179113461L;
    private final int soSndBuf;
    private final int soRcvBuf;
    private final boolean soKeepAlive;
    private final boolean soReuseAddr;
    private final boolean tcpNoDelay;
    private final int soLinger;
    private final int writeBufferHighWaterMark;
    private final int writeBufferLowWaterMark;

    private NetOptions(int soSndBuf, int soRcvBuf, boolean soKeepAlive, boolean soReuseAddr, boolean tcpNoDelay, int soLinger, int writeBufferHighWaterMark, int writeBufferLowWaterMark) {
        this.soSndBuf = soSndBuf;
        this.soRcvBuf = soRcvBuf;
        this.soKeepAlive = soKeepAlive;
        this.soReuseAddr = soReuseAddr;
        this.tcpNoDelay = tcpNoDelay;
        this.soLinger = soLinger;
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    @Override
    public NetOptions copy() {
        return new NetOptions(this.soSndBuf, this.soRcvBuf, this.soKeepAlive, this.soReuseAddr, this.tcpNoDelay, this.soLinger, this.writeBufferHighWaterMark, this.writeBufferLowWaterMark);
    }

    public static NetOptions ofDefault() {
        return new NetOptionsBuilder().build();
    }

    public static NetOptionsBuilder options() {
        return new NetOptionsBuilder();
    }

    public int soSndBuf() {
        return this.soSndBuf;
    }

    public int soRcvBuf() {
        return this.soRcvBuf;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isSoReuseAddr() {
        return this.soReuseAddr;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int soLinger() {
        return this.soLinger;
    }

    public int writeBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public int writeBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public String toString() {
        return new StringJoiner(", ", NetOptions.class.getSimpleName() + "[", "]").add("soSndBuf=" + this.soSndBuf).add("soRcvBuf=" + this.soRcvBuf).add("soKeepAlive=" + this.soKeepAlive).add("soReuseAddr=" + this.soReuseAddr).add("tcpNoDelay=" + this.tcpNoDelay).add("soLinger=" + this.soLinger).add("writeBufferHighWaterMark=" + this.writeBufferHighWaterMark).add("writeBufferLowWaterMark=" + this.writeBufferLowWaterMark).toString();
    }

    public static class NetOptionsBuilder {
        private int soSndBuf = -1;
        private int soRcvBuf = -1;
        private boolean soKeepAlive = true;
        private boolean soReuseAddr = false;
        private boolean tcpNoDelay = true;
        private int soLinger = -1;
        private int writeBufferHighWaterMark = -1;
        private int writeBufferLowWaterMark = -1;

        NetOptionsBuilder() {
        }

        public NetOptionsBuilder soSndBuf(int soSndBuf) {
            this.soSndBuf = soSndBuf;
            return this;
        }

        public NetOptionsBuilder soRcvBuf(int soRcvBuf) {
            this.soRcvBuf = soRcvBuf;
            return this;
        }

        public NetOptionsBuilder soKeepAlive(boolean soKeepAlive) {
            this.soKeepAlive = soKeepAlive;
            return this;
        }

        public NetOptionsBuilder soReuseAddr(boolean soReuseAddr) {
            this.soReuseAddr = soReuseAddr;
            return this;
        }

        public NetOptionsBuilder tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public NetOptionsBuilder soLinger(int soLinger) {
            this.soLinger = soLinger;
            return this;
        }

        public NetOptionsBuilder writeBufferHighWaterMark(int writeBufferHighWaterMark) {
            this.writeBufferHighWaterMark = writeBufferHighWaterMark;
            return this;
        }

        public NetOptionsBuilder writeBufferLowWaterMark(int writeBufferLowWaterMark) {
            this.writeBufferLowWaterMark = writeBufferLowWaterMark;
            return this;
        }

        public NetOptions build() {
            return new NetOptions(this.soSndBuf, this.soRcvBuf, this.soKeepAlive, this.soReuseAddr, this.tcpNoDelay, this.soLinger, this.writeBufferHighWaterMark, this.writeBufferLowWaterMark);
        }
    }
}

