/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpclient.core.config;

import esa.commons.Checks;
import io.esastack.httpclient.core.Reusable;
import io.esastack.httpclient.core.exec.RetryPredicate;
import io.esastack.httpclient.core.exec.RetryPredicateImpl;
import java.io.Serializable;
import java.util.StringJoiner;
import java.util.function.IntToLongFunction;

public class RetryOptions
implements Reusable<RetryOptions>,
Serializable {
    private static final long serialVersionUID = -4016995314366331767L;
    private final int maxRetries;
    private final transient RetryPredicate predicate;
    private final transient IntToLongFunction intervalMillis;

    private RetryOptions(int maxRetries, RetryPredicate predicate, IntToLongFunction intervalMillis) {
        Checks.checkNotNull((Object)predicate, (String)"predicate");
        this.maxRetries = maxRetries;
        this.predicate = predicate;
        this.intervalMillis = intervalMillis;
    }

    public static RetryOptions ofDefault() {
        return new RetryOptionsBuilder().build();
    }

    public static RetryOptionsBuilder options() {
        return new RetryOptionsBuilder();
    }

    @Override
    public RetryOptions copy() {
        return new RetryOptions(this.maxRetries, this.predicate, this.intervalMillis);
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public RetryPredicate predicate() {
        return this.predicate;
    }

    public IntToLongFunction intervalMillis() {
        return this.intervalMillis;
    }

    public String toString() {
        return new StringJoiner(", ", RetryOptions.class.getSimpleName() + "[", "]").add("maxRetries=" + this.maxRetries).add("predicate=" + this.predicate).add("intervalMillis=" + this.intervalMillis).toString();
    }

    public static class RetryOptionsBuilder {
        private int maxRetries = 3;
        private RetryPredicate predicate = RetryPredicateImpl.DEFAULT;
        private IntToLongFunction intervalMillis;

        RetryOptionsBuilder() {
        }

        public RetryOptionsBuilder intervalMs(IntToLongFunction intervalMillis) {
            this.intervalMillis = intervalMillis;
            return this;
        }

        public RetryOptionsBuilder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public RetryOptionsBuilder predicate(RetryPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public RetryOptions build() {
            return new RetryOptions(this.maxRetries, this.predicate, this.intervalMillis);
        }
    }
}

